<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BestelltesProdukt StructType
 * @subpackage Structs
 */
class BestelltesProdukt extends AbstractStructBase
{
    /**
     * The ArtNr
     * @var string
     */
    public $ArtNr;
    /**
     * The Form
     * @var string
     */
    public $Form;
    /**
     * The Stueck
     * @var int
     */
    public $Stueck;
    /**
     * The ProduktPreisMitRabatt
     * @var float
     */
    public $ProduktPreisMitRabatt;
    /**
     * The ProduktEndpreis
     * @var float
     */
    public $ProduktEndpreis;
    /**
     * The Laenge
     * @var int
     */
    public $Laenge;
    /**
     * The Breite
     * @var int
     */
    public $Breite;
    /**
     * The Legierung
     * @var string
     */
    public $Legierung;
    /**
     * The Abmessungen
     * @var string
     */
    public $Abmessungen;
    /**
     * The SaegekostenStueck
     * @var float
     */
    public $SaegekostenStueck;
    /**
     * The ProduktPreis
     * @var float
     */
    public $ProduktPreis;
    /**
     * Constructor method for BestelltesProdukt
     * @uses BestelltesProdukt::setArtNr()
     * @uses BestelltesProdukt::setForm()
     * @uses BestelltesProdukt::setStueck()
     * @uses BestelltesProdukt::setProduktPreisMitRabatt()
     * @uses BestelltesProdukt::setProduktEndpreis()
     * @uses BestelltesProdukt::setLaenge()
     * @uses BestelltesProdukt::setBreite()
     * @uses BestelltesProdukt::setLegierung()
     * @uses BestelltesProdukt::setAbmessungen()
     * @uses BestelltesProdukt::setSaegekostenStueck()
     * @uses BestelltesProdukt::setProduktPreis()
     * @param string $artNr
     * @param string $form
     * @param int $stueck
     * @param float $produktPreisMitRabatt
     * @param float $produktEndpreis
     * @param int $laenge
     * @param int $breite
     * @param string $legierung
     * @param string $abmessungen
     * @param float $saegekostenStueck
     * @param float $produktPreis
     */
    public function __construct($artNr = null, $form = null, $stueck = null, $produktPreisMitRabatt = null, $produktEndpreis = null, $laenge = null, $breite = null, $legierung = null, $abmessungen = null, $saegekostenStueck = null, $produktPreis = null)
    {
        $this
            ->setArtNr($artNr)
            ->setForm($form)
            ->setStueck($stueck)
            ->setProduktPreisMitRabatt($produktPreisMitRabatt)
            ->setProduktEndpreis($produktEndpreis)
            ->setLaenge($laenge)
            ->setBreite($breite)
            ->setLegierung($legierung)
            ->setAbmessungen($abmessungen)
            ->setSaegekostenStueck($saegekostenStueck)
            ->setProduktPreis($produktPreis);
    }
    /**
     * Get ArtNr value
     * @return string|null
     */
    public function getArtNr()
    {
        return $this->ArtNr;
    }
    /**
     * Set ArtNr value
     * @param string $artNr
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setArtNr($artNr = null)
    {
        // validation for constraint: string
        if (!is_null($artNr) && !is_string($artNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artNr, true), gettype($artNr)), __LINE__);
        }
        $this->ArtNr = $artNr;
        return $this;
    }
    /**
     * Get Form value
     * @return string|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param string $form
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setForm($form = null)
    {
        // validation for constraint: string
        if (!is_null($form) && !is_string($form)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($form, true), gettype($form)), __LINE__);
        }
        $this->Form = $form;
        return $this;
    }
    /**
     * Get Stueck value
     * @return int|null
     */
    public function getStueck()
    {
        return $this->Stueck;
    }
    /**
     * Set Stueck value
     * @param int $stueck
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setStueck($stueck = null)
    {
        // validation for constraint: int
        if (!is_null($stueck) && !(is_int($stueck) || ctype_digit($stueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stueck, true), gettype($stueck)), __LINE__);
        }
        $this->Stueck = $stueck;
        return $this;
    }
    /**
     * Get ProduktPreisMitRabatt value
     * @return float|null
     */
    public function getProduktPreisMitRabatt()
    {
        return $this->ProduktPreisMitRabatt;
    }
    /**
     * Set ProduktPreisMitRabatt value
     * @param float $produktPreisMitRabatt
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setProduktPreisMitRabatt($produktPreisMitRabatt = null)
    {
        // validation for constraint: float
        if (!is_null($produktPreisMitRabatt) && !(is_float($produktPreisMitRabatt) || is_numeric($produktPreisMitRabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($produktPreisMitRabatt, true), gettype($produktPreisMitRabatt)), __LINE__);
        }
        $this->ProduktPreisMitRabatt = $produktPreisMitRabatt;
        return $this;
    }
    /**
     * Get ProduktEndpreis value
     * @return float|null
     */
    public function getProduktEndpreis()
    {
        return $this->ProduktEndpreis;
    }
    /**
     * Set ProduktEndpreis value
     * @param float $produktEndpreis
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setProduktEndpreis($produktEndpreis = null)
    {
        // validation for constraint: float
        if (!is_null($produktEndpreis) && !(is_float($produktEndpreis) || is_numeric($produktEndpreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($produktEndpreis, true), gettype($produktEndpreis)), __LINE__);
        }
        $this->ProduktEndpreis = $produktEndpreis;
        return $this;
    }
    /**
     * Get Laenge value
     * @return int|null
     */
    public function getLaenge()
    {
        return $this->Laenge;
    }
    /**
     * Set Laenge value
     * @param int $laenge
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setLaenge($laenge = null)
    {
        // validation for constraint: int
        if (!is_null($laenge) && !(is_int($laenge) || ctype_digit($laenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($laenge, true), gettype($laenge)), __LINE__);
        }
        $this->Laenge = $laenge;
        return $this;
    }
    /**
     * Get Breite value
     * @return int|null
     */
    public function getBreite()
    {
        return $this->Breite;
    }
    /**
     * Set Breite value
     * @param int $breite
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setBreite($breite = null)
    {
        // validation for constraint: int
        if (!is_null($breite) && !(is_int($breite) || ctype_digit($breite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($breite, true), gettype($breite)), __LINE__);
        }
        $this->Breite = $breite;
        return $this;
    }
    /**
     * Get Legierung value
     * @return string|null
     */
    public function getLegierung()
    {
        return $this->Legierung;
    }
    /**
     * Set Legierung value
     * @param string $legierung
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setLegierung($legierung = null)
    {
        // validation for constraint: string
        if (!is_null($legierung) && !is_string($legierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legierung, true), gettype($legierung)), __LINE__);
        }
        $this->Legierung = $legierung;
        return $this;
    }
    /**
     * Get Abmessungen value
     * @return string|null
     */
    public function getAbmessungen()
    {
        return $this->Abmessungen;
    }
    /**
     * Set Abmessungen value
     * @param string $abmessungen
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setAbmessungen($abmessungen = null)
    {
        // validation for constraint: string
        if (!is_null($abmessungen) && !is_string($abmessungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abmessungen, true), gettype($abmessungen)), __LINE__);
        }
        $this->Abmessungen = $abmessungen;
        return $this;
    }
    /**
     * Get SaegekostenStueck value
     * @return float|null
     */
    public function getSaegekostenStueck()
    {
        return $this->SaegekostenStueck;
    }
    /**
     * Set SaegekostenStueck value
     * @param float $saegekostenStueck
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setSaegekostenStueck($saegekostenStueck = null)
    {
        // validation for constraint: float
        if (!is_null($saegekostenStueck) && !(is_float($saegekostenStueck) || is_numeric($saegekostenStueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saegekostenStueck, true), gettype($saegekostenStueck)), __LINE__);
        }
        $this->SaegekostenStueck = $saegekostenStueck;
        return $this;
    }
    /**
     * Get ProduktPreis value
     * @return float|null
     */
    public function getProduktPreis()
    {
        return $this->ProduktPreis;
    }
    /**
     * Set ProduktPreis value
     * @param float $produktPreis
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public function setProduktPreis($produktPreis = null)
    {
        // validation for constraint: float
        if (!is_null($produktPreis) && !(is_float($produktPreis) || is_numeric($produktPreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($produktPreis, true), gettype($produktPreis)), __LINE__);
        }
        $this->ProduktPreis = $produktPreis;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\BestelltesProdukt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
