<?php

namespace wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Auth ServiceType
 * @subpackage Services
 */
class Auth extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named auth
     * Meta information extracted from the WSDL
     * - documentation: Authentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $benutzer
     * @param string $passwort
     * @return string|bool
     */
    public function auth($benutzer, $passwort)
    {
        try {
            $this->setResult($this->getSoapClient()->auth($benutzer, $passwort));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
