<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bestellung StructType
 * @subpackage Structs
 */
class Bestellung extends AbstractStructBase
{
    /**
     * The Bestelldetails
     * @var \wsdl\StructType\Bestelldetails
     */
    public $Bestelldetails;
    /**
     * The Produkte
     * Meta information extracted from the WSDL
     * - arrayType: tns:BestelltesProdukt[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var \wsdl\StructType\BestelltesProdukt[]
     */
    public $Produkte;
    /**
     * The Rechnungsadresse
     * @var \wsdl\StructType\Rechnungsadresse
     */
    public $Rechnungsadresse;
    /**
     * The Lieferadresse
     * @var \wsdl\StructType\Lieferadresse
     */
    public $Lieferadresse;
    /**
     * Constructor method for Bestellung
     * @uses Bestellung::setBestelldetails()
     * @uses Bestellung::setProdukte()
     * @uses Bestellung::setRechnungsadresse()
     * @uses Bestellung::setLieferadresse()
     * @param \wsdl\StructType\Bestelldetails $bestelldetails
     * @param \wsdl\StructType\BestelltesProdukt[] $produkte
     * @param \wsdl\StructType\Rechnungsadresse $rechnungsadresse
     * @param \wsdl\StructType\Lieferadresse $lieferadresse
     */
    public function __construct(\wsdl\StructType\Bestelldetails $bestelldetails = null, array $produkte = array(), \wsdl\StructType\Rechnungsadresse $rechnungsadresse = null, \wsdl\StructType\Lieferadresse $lieferadresse = null)
    {
        $this
            ->setBestelldetails($bestelldetails)
            ->setProdukte($produkte)
            ->setRechnungsadresse($rechnungsadresse)
            ->setLieferadresse($lieferadresse);
    }
    /**
     * Get Bestelldetails value
     * @return \wsdl\StructType\Bestelldetails|null
     */
    public function getBestelldetails()
    {
        return $this->Bestelldetails;
    }
    /**
     * Set Bestelldetails value
     * @param \wsdl\StructType\Bestelldetails $bestelldetails
     * @return \wsdl\StructType\Bestellung
     */
    public function setBestelldetails(\wsdl\StructType\Bestelldetails $bestelldetails = null)
    {
        $this->Bestelldetails = $bestelldetails;
        return $this;
    }
    /**
     * Get Produkte value
     * @return \wsdl\StructType\BestelltesProdukt[]|null
     */
    public function getProdukte()
    {
        return $this->Produkte;
    }
    /**
     * This method is responsible for validating the values passed to the setProdukte method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProdukte method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProdukteForArrayConstraintsFromSetProdukte(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bestellungProdukteItem) {
            // validation for constraint: itemType
            if (!$bestellungProdukteItem instanceof \wsdl\StructType\BestelltesProdukt) {
                $invalidValues[] = is_object($bestellungProdukteItem) ? get_class($bestellungProdukteItem) : sprintf('%s(%s)', gettype($bestellungProdukteItem), var_export($bestellungProdukteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Produkte property can only contain items of type \wsdl\StructType\BestelltesProdukt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Produkte value
     * @throws \InvalidArgumentException
     * @param \wsdl\StructType\BestelltesProdukt[] $produkte
     * @return \wsdl\StructType\Bestellung
     */
    public function setProdukte(array $produkte = array())
    {
        // validation for constraint: array
        if ('' !== ($produkteArrayErrorMessage = self::validateProdukteForArrayConstraintsFromSetProdukte($produkte))) {
            throw new \InvalidArgumentException($produkteArrayErrorMessage, __LINE__);
        }
        $this->Produkte = $produkte;
        return $this;
    }
    /**
     * Add item to Produkte value
     * @throws \InvalidArgumentException
     * @param \wsdl\StructType\BestelltesProdukt $item
     * @return \wsdl\StructType\Bestellung
     */
    public function addToProdukte(\wsdl\StructType\BestelltesProdukt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \wsdl\StructType\BestelltesProdukt) {
            throw new \InvalidArgumentException(sprintf('The Produkte property can only contain items of type \wsdl\StructType\BestelltesProdukt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Produkte[] = $item;
        return $this;
    }
    /**
     * Get Rechnungsadresse value
     * @return \wsdl\StructType\Rechnungsadresse|null
     */
    public function getRechnungsadresse()
    {
        return $this->Rechnungsadresse;
    }
    /**
     * Set Rechnungsadresse value
     * @param \wsdl\StructType\Rechnungsadresse $rechnungsadresse
     * @return \wsdl\StructType\Bestellung
     */
    public function setRechnungsadresse(\wsdl\StructType\Rechnungsadresse $rechnungsadresse = null)
    {
        $this->Rechnungsadresse = $rechnungsadresse;
        return $this;
    }
    /**
     * Get Lieferadresse value
     * @return \wsdl\StructType\Lieferadresse|null
     */
    public function getLieferadresse()
    {
        return $this->Lieferadresse;
    }
    /**
     * Set Lieferadresse value
     * @param \wsdl\StructType\Lieferadresse $lieferadresse
     * @return \wsdl\StructType\Bestellung
     */
    public function setLieferadresse(\wsdl\StructType\Lieferadresse $lieferadresse = null)
    {
        $this->Lieferadresse = $lieferadresse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\Bestellung
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
