<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bestelldetails StructType
 * @subpackage Structs
 */
class Bestelldetails extends AbstractStructBase
{
    /**
     * The Bestellnummer
     * @var int
     */
    public $Bestellnummer;
    /**
     * The UserId
     * @var int
     */
    public $UserId;
    /**
     * The Rechnungsbetrag
     * @var float
     */
    public $Rechnungsbetrag;
    /**
     * The Zwischensumme
     * @var float
     */
    public $Zwischensumme;
    /**
     * The Mwst
     * @var float
     */
    public $Mwst;
    /**
     * The Versandkosten
     * @var float
     */
    public $Versandkosten;
    /**
     * The VersandkostenMwst
     * @var float
     */
    public $VersandkostenMwst;
    /**
     * The Ueberlaenge
     * @var float
     */
    public $Ueberlaenge;
    /**
     * The Verpackungskosten
     * @var float
     */
    public $Verpackungskosten;
    /**
     * The Zoll
     * @var float
     */
    public $Zoll;
    /**
     * The GutscheinRabatt
     * @var float
     */
    public $GutscheinRabatt;
    /**
     * The GutscheinCode
     * @var string
     */
    public $GutscheinCode;
    /**
     * The Nachnahme
     * @var float
     */
    public $Nachnahme;
    /**
     * The Waehrung
     * @var string
     */
    public $Waehrung;
    /**
     * The Versandart
     * @var string
     */
    public $Versandart;
    /**
     * The Bemerkung
     * @var string
     */
    public $Bemerkung;
    /**
     * The IhreBestellnummer
     * @var string
     */
    public $IhreBestellnummer;
    /**
     * The IPAdresse
     * @var string
     */
    public $IPAdresse;
    /**
     * The Rabatt
     * @var float
     */
    public $Rabatt;
    /**
     * The Bestellstatus
     * @var string
     */
    public $Bestellstatus;
    /**
     * The BestellstatusDatumZeit
     * @var string
     */
    public $BestellstatusDatumZeit;
    /**
     * The KontaktAufnehmen
     * @var bool
     */
    public $KontaktAufnehmen;
    /**
     * The Gesamtgewicht
     * @var float
     */
    public $Gesamtgewicht;
    /**
     * The StatusID
     * @var int
     */
    public $StatusID;
    /**
     * The Bezahlmethode
     * @var string
     */
    public $Bezahlmethode;
    /**
     * The DeviceType
     * @var string
     */
    public $DeviceType;
    /**
     * Constructor method for Bestelldetails
     * @uses Bestelldetails::setBestellnummer()
     * @uses Bestelldetails::setUserId()
     * @uses Bestelldetails::setRechnungsbetrag()
     * @uses Bestelldetails::setZwischensumme()
     * @uses Bestelldetails::setMwst()
     * @uses Bestelldetails::setVersandkosten()
     * @uses Bestelldetails::setVersandkostenMwst()
     * @uses Bestelldetails::setUeberlaenge()
     * @uses Bestelldetails::setVerpackungskosten()
     * @uses Bestelldetails::setZoll()
     * @uses Bestelldetails::setGutscheinRabatt()
     * @uses Bestelldetails::setGutscheinCode()
     * @uses Bestelldetails::setNachnahme()
     * @uses Bestelldetails::setWaehrung()
     * @uses Bestelldetails::setVersandart()
     * @uses Bestelldetails::setBemerkung()
     * @uses Bestelldetails::setIhreBestellnummer()
     * @uses Bestelldetails::setIPAdresse()
     * @uses Bestelldetails::setRabatt()
     * @uses Bestelldetails::setBestellstatus()
     * @uses Bestelldetails::setBestellstatusDatumZeit()
     * @uses Bestelldetails::setKontaktAufnehmen()
     * @uses Bestelldetails::setGesamtgewicht()
     * @uses Bestelldetails::setStatusID()
     * @uses Bestelldetails::setBezahlmethode()
     * @uses Bestelldetails::setDeviceType()
     * @param int $bestellnummer
     * @param int $userId
     * @param float $rechnungsbetrag
     * @param float $zwischensumme
     * @param float $mwst
     * @param float $versandkosten
     * @param float $versandkostenMwst
     * @param float $ueberlaenge
     * @param float $verpackungskosten
     * @param float $zoll
     * @param float $gutscheinRabatt
     * @param string $gutscheinCode
     * @param float $nachnahme
     * @param string $waehrung
     * @param string $versandart
     * @param string $bemerkung
     * @param string $ihreBestellnummer
     * @param string $iPAdresse
     * @param float $rabatt
     * @param string $bestellstatus
     * @param string $bestellstatusDatumZeit
     * @param bool $kontaktAufnehmen
     * @param float $gesamtgewicht
     * @param int $statusID
     * @param string $bezahlmethode
     * @param string $deviceType
     */
    public function __construct($bestellnummer = null, $userId = null, $rechnungsbetrag = null, $zwischensumme = null, $mwst = null, $versandkosten = null, $versandkostenMwst = null, $ueberlaenge = null, $verpackungskosten = null, $zoll = null, $gutscheinRabatt = null, $gutscheinCode = null, $nachnahme = null, $waehrung = null, $versandart = null, $bemerkung = null, $ihreBestellnummer = null, $iPAdresse = null, $rabatt = null, $bestellstatus = null, $bestellstatusDatumZeit = null, $kontaktAufnehmen = null, $gesamtgewicht = null, $statusID = null, $bezahlmethode = null, $deviceType = null)
    {
        $this
            ->setBestellnummer($bestellnummer)
            ->setUserId($userId)
            ->setRechnungsbetrag($rechnungsbetrag)
            ->setZwischensumme($zwischensumme)
            ->setMwst($mwst)
            ->setVersandkosten($versandkosten)
            ->setVersandkostenMwst($versandkostenMwst)
            ->setUeberlaenge($ueberlaenge)
            ->setVerpackungskosten($verpackungskosten)
            ->setZoll($zoll)
            ->setGutscheinRabatt($gutscheinRabatt)
            ->setGutscheinCode($gutscheinCode)
            ->setNachnahme($nachnahme)
            ->setWaehrung($waehrung)
            ->setVersandart($versandart)
            ->setBemerkung($bemerkung)
            ->setIhreBestellnummer($ihreBestellnummer)
            ->setIPAdresse($iPAdresse)
            ->setRabatt($rabatt)
            ->setBestellstatus($bestellstatus)
            ->setBestellstatusDatumZeit($bestellstatusDatumZeit)
            ->setKontaktAufnehmen($kontaktAufnehmen)
            ->setGesamtgewicht($gesamtgewicht)
            ->setStatusID($statusID)
            ->setBezahlmethode($bezahlmethode)
            ->setDeviceType($deviceType);
    }
    /**
     * Get Bestellnummer value
     * @return int|null
     */
    public function getBestellnummer()
    {
        return $this->Bestellnummer;
    }
    /**
     * Set Bestellnummer value
     * @param int $bestellnummer
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setBestellnummer($bestellnummer = null)
    {
        // validation for constraint: int
        if (!is_null($bestellnummer) && !(is_int($bestellnummer) || ctype_digit($bestellnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bestellnummer, true), gettype($bestellnummer)), __LINE__);
        }
        $this->Bestellnummer = $bestellnummer;
        return $this;
    }
    /**
     * Get UserId value
     * @return int|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get Rechnungsbetrag value
     * @return float|null
     */
    public function getRechnungsbetrag()
    {
        return $this->Rechnungsbetrag;
    }
    /**
     * Set Rechnungsbetrag value
     * @param float $rechnungsbetrag
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setRechnungsbetrag($rechnungsbetrag = null)
    {
        // validation for constraint: float
        if (!is_null($rechnungsbetrag) && !(is_float($rechnungsbetrag) || is_numeric($rechnungsbetrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rechnungsbetrag, true), gettype($rechnungsbetrag)), __LINE__);
        }
        $this->Rechnungsbetrag = $rechnungsbetrag;
        return $this;
    }
    /**
     * Get Zwischensumme value
     * @return float|null
     */
    public function getZwischensumme()
    {
        return $this->Zwischensumme;
    }
    /**
     * Set Zwischensumme value
     * @param float $zwischensumme
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setZwischensumme($zwischensumme = null)
    {
        // validation for constraint: float
        if (!is_null($zwischensumme) && !(is_float($zwischensumme) || is_numeric($zwischensumme))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zwischensumme, true), gettype($zwischensumme)), __LINE__);
        }
        $this->Zwischensumme = $zwischensumme;
        return $this;
    }
    /**
     * Get Mwst value
     * @return float|null
     */
    public function getMwst()
    {
        return $this->Mwst;
    }
    /**
     * Set Mwst value
     * @param float $mwst
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setMwst($mwst = null)
    {
        // validation for constraint: float
        if (!is_null($mwst) && !(is_float($mwst) || is_numeric($mwst))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mwst, true), gettype($mwst)), __LINE__);
        }
        $this->Mwst = $mwst;
        return $this;
    }
    /**
     * Get Versandkosten value
     * @return float|null
     */
    public function getVersandkosten()
    {
        return $this->Versandkosten;
    }
    /**
     * Set Versandkosten value
     * @param float $versandkosten
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setVersandkosten($versandkosten = null)
    {
        // validation for constraint: float
        if (!is_null($versandkosten) && !(is_float($versandkosten) || is_numeric($versandkosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($versandkosten, true), gettype($versandkosten)), __LINE__);
        }
        $this->Versandkosten = $versandkosten;
        return $this;
    }
    /**
     * Get VersandkostenMwst value
     * @return float|null
     */
    public function getVersandkostenMwst()
    {
        return $this->VersandkostenMwst;
    }
    /**
     * Set VersandkostenMwst value
     * @param float $versandkostenMwst
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setVersandkostenMwst($versandkostenMwst = null)
    {
        // validation for constraint: float
        if (!is_null($versandkostenMwst) && !(is_float($versandkostenMwst) || is_numeric($versandkostenMwst))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($versandkostenMwst, true), gettype($versandkostenMwst)), __LINE__);
        }
        $this->VersandkostenMwst = $versandkostenMwst;
        return $this;
    }
    /**
     * Get Ueberlaenge value
     * @return float|null
     */
    public function getUeberlaenge()
    {
        return $this->Ueberlaenge;
    }
    /**
     * Set Ueberlaenge value
     * @param float $ueberlaenge
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setUeberlaenge($ueberlaenge = null)
    {
        // validation for constraint: float
        if (!is_null($ueberlaenge) && !(is_float($ueberlaenge) || is_numeric($ueberlaenge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ueberlaenge, true), gettype($ueberlaenge)), __LINE__);
        }
        $this->Ueberlaenge = $ueberlaenge;
        return $this;
    }
    /**
     * Get Verpackungskosten value
     * @return float|null
     */
    public function getVerpackungskosten()
    {
        return $this->Verpackungskosten;
    }
    /**
     * Set Verpackungskosten value
     * @param float $verpackungskosten
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setVerpackungskosten($verpackungskosten = null)
    {
        // validation for constraint: float
        if (!is_null($verpackungskosten) && !(is_float($verpackungskosten) || is_numeric($verpackungskosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($verpackungskosten, true), gettype($verpackungskosten)), __LINE__);
        }
        $this->Verpackungskosten = $verpackungskosten;
        return $this;
    }
    /**
     * Get Zoll value
     * @return float|null
     */
    public function getZoll()
    {
        return $this->Zoll;
    }
    /**
     * Set Zoll value
     * @param float $zoll
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setZoll($zoll = null)
    {
        // validation for constraint: float
        if (!is_null($zoll) && !(is_float($zoll) || is_numeric($zoll))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zoll, true), gettype($zoll)), __LINE__);
        }
        $this->Zoll = $zoll;
        return $this;
    }
    /**
     * Get GutscheinRabatt value
     * @return float|null
     */
    public function getGutscheinRabatt()
    {
        return $this->GutscheinRabatt;
    }
    /**
     * Set GutscheinRabatt value
     * @param float $gutscheinRabatt
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setGutscheinRabatt($gutscheinRabatt = null)
    {
        // validation for constraint: float
        if (!is_null($gutscheinRabatt) && !(is_float($gutscheinRabatt) || is_numeric($gutscheinRabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gutscheinRabatt, true), gettype($gutscheinRabatt)), __LINE__);
        }
        $this->GutscheinRabatt = $gutscheinRabatt;
        return $this;
    }
    /**
     * Get GutscheinCode value
     * @return string|null
     */
    public function getGutscheinCode()
    {
        return $this->GutscheinCode;
    }
    /**
     * Set GutscheinCode value
     * @param string $gutscheinCode
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setGutscheinCode($gutscheinCode = null)
    {
        // validation for constraint: string
        if (!is_null($gutscheinCode) && !is_string($gutscheinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gutscheinCode, true), gettype($gutscheinCode)), __LINE__);
        }
        $this->GutscheinCode = $gutscheinCode;
        return $this;
    }
    /**
     * Get Nachnahme value
     * @return float|null
     */
    public function getNachnahme()
    {
        return $this->Nachnahme;
    }
    /**
     * Set Nachnahme value
     * @param float $nachnahme
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setNachnahme($nachnahme = null)
    {
        // validation for constraint: float
        if (!is_null($nachnahme) && !(is_float($nachnahme) || is_numeric($nachnahme))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nachnahme, true), gettype($nachnahme)), __LINE__);
        }
        $this->Nachnahme = $nachnahme;
        return $this;
    }
    /**
     * Get Waehrung value
     * @return string|null
     */
    public function getWaehrung()
    {
        return $this->Waehrung;
    }
    /**
     * Set Waehrung value
     * @param string $waehrung
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setWaehrung($waehrung = null)
    {
        // validation for constraint: string
        if (!is_null($waehrung) && !is_string($waehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waehrung, true), gettype($waehrung)), __LINE__);
        }
        $this->Waehrung = $waehrung;
        return $this;
    }
    /**
     * Get Versandart value
     * @return string|null
     */
    public function getVersandart()
    {
        return $this->Versandart;
    }
    /**
     * Set Versandart value
     * @param string $versandart
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setVersandart($versandart = null)
    {
        // validation for constraint: string
        if (!is_null($versandart) && !is_string($versandart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versandart, true), gettype($versandart)), __LINE__);
        }
        $this->Versandart = $versandart;
        return $this;
    }
    /**
     * Get Bemerkung value
     * @return string|null
     */
    public function getBemerkung()
    {
        return $this->Bemerkung;
    }
    /**
     * Set Bemerkung value
     * @param string $bemerkung
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setBemerkung($bemerkung = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkung) && !is_string($bemerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkung, true), gettype($bemerkung)), __LINE__);
        }
        $this->Bemerkung = $bemerkung;
        return $this;
    }
    /**
     * Get IhreBestellnummer value
     * @return string|null
     */
    public function getIhreBestellnummer()
    {
        return $this->IhreBestellnummer;
    }
    /**
     * Set IhreBestellnummer value
     * @param string $ihreBestellnummer
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setIhreBestellnummer($ihreBestellnummer = null)
    {
        // validation for constraint: string
        if (!is_null($ihreBestellnummer) && !is_string($ihreBestellnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ihreBestellnummer, true), gettype($ihreBestellnummer)), __LINE__);
        }
        $this->IhreBestellnummer = $ihreBestellnummer;
        return $this;
    }
    /**
     * Get IPAdresse value
     * @return string|null
     */
    public function getIPAdresse()
    {
        return $this->IPAdresse;
    }
    /**
     * Set IPAdresse value
     * @param string $iPAdresse
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setIPAdresse($iPAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($iPAdresse) && !is_string($iPAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPAdresse, true), gettype($iPAdresse)), __LINE__);
        }
        $this->IPAdresse = $iPAdresse;
        return $this;
    }
    /**
     * Get Rabatt value
     * @return float|null
     */
    public function getRabatt()
    {
        return $this->Rabatt;
    }
    /**
     * Set Rabatt value
     * @param float $rabatt
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setRabatt($rabatt = null)
    {
        // validation for constraint: float
        if (!is_null($rabatt) && !(is_float($rabatt) || is_numeric($rabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rabatt, true), gettype($rabatt)), __LINE__);
        }
        $this->Rabatt = $rabatt;
        return $this;
    }
    /**
     * Get Bestellstatus value
     * @return string|null
     */
    public function getBestellstatus()
    {
        return $this->Bestellstatus;
    }
    /**
     * Set Bestellstatus value
     * @param string $bestellstatus
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setBestellstatus($bestellstatus = null)
    {
        // validation for constraint: string
        if (!is_null($bestellstatus) && !is_string($bestellstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestellstatus, true), gettype($bestellstatus)), __LINE__);
        }
        $this->Bestellstatus = $bestellstatus;
        return $this;
    }
    /**
     * Get BestellstatusDatumZeit value
     * @return string|null
     */
    public function getBestellstatusDatumZeit()
    {
        return $this->BestellstatusDatumZeit;
    }
    /**
     * Set BestellstatusDatumZeit value
     * @param string $bestellstatusDatumZeit
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setBestellstatusDatumZeit($bestellstatusDatumZeit = null)
    {
        // validation for constraint: string
        if (!is_null($bestellstatusDatumZeit) && !is_string($bestellstatusDatumZeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestellstatusDatumZeit, true), gettype($bestellstatusDatumZeit)), __LINE__);
        }
        $this->BestellstatusDatumZeit = $bestellstatusDatumZeit;
        return $this;
    }
    /**
     * Get KontaktAufnehmen value
     * @return bool|null
     */
    public function getKontaktAufnehmen()
    {
        return $this->KontaktAufnehmen;
    }
    /**
     * Set KontaktAufnehmen value
     * @param bool $kontaktAufnehmen
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setKontaktAufnehmen($kontaktAufnehmen = null)
    {
        // validation for constraint: boolean
        if (!is_null($kontaktAufnehmen) && !is_bool($kontaktAufnehmen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kontaktAufnehmen, true), gettype($kontaktAufnehmen)), __LINE__);
        }
        $this->KontaktAufnehmen = $kontaktAufnehmen;
        return $this;
    }
    /**
     * Get Gesamtgewicht value
     * @return float|null
     */
    public function getGesamtgewicht()
    {
        return $this->Gesamtgewicht;
    }
    /**
     * Set Gesamtgewicht value
     * @param float $gesamtgewicht
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setGesamtgewicht($gesamtgewicht = null)
    {
        // validation for constraint: float
        if (!is_null($gesamtgewicht) && !(is_float($gesamtgewicht) || is_numeric($gesamtgewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gesamtgewicht, true), gettype($gesamtgewicht)), __LINE__);
        }
        $this->Gesamtgewicht = $gesamtgewicht;
        return $this;
    }
    /**
     * Get StatusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->StatusID;
    }
    /**
     * Set StatusID value
     * @param int $statusID
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->StatusID = $statusID;
        return $this;
    }
    /**
     * Get Bezahlmethode value
     * @return string|null
     */
    public function getBezahlmethode()
    {
        return $this->Bezahlmethode;
    }
    /**
     * Set Bezahlmethode value
     * @param string $bezahlmethode
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setBezahlmethode($bezahlmethode = null)
    {
        // validation for constraint: string
        if (!is_null($bezahlmethode) && !is_string($bezahlmethode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezahlmethode, true), gettype($bezahlmethode)), __LINE__);
        }
        $this->Bezahlmethode = $bezahlmethode;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @param string $deviceType
     * @return \wsdl\StructType\Bestelldetails
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: string
        if (!is_null($deviceType) && !is_string($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceType, true), gettype($deviceType)), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\Bestelldetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
