<?php

namespace wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Produkte ServiceType
 * @subpackage Services
 */
class Produkte extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProdukteAktualisieren
     * Meta information extracted from the WSDL
     * - documentation: Produkte Aktualisieren
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $authCode
     * @param \wsdl\StructType\Produkt[] $produkte
     * @return string|bool
     */
    public function ProdukteAktualisieren($authCode, array $produkte)
    {
        try {
            $this->setResult($this->getSoapClient()->ProdukteAktualisieren($authCode, $produkte));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
