<?php

namespace wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bestellstatus ServiceType
 * @subpackage Services
 */
class Bestellstatus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BestellstatusAktualisieren
     * Meta information extracted from the WSDL
     * - documentation: Bestellstatus Aktualisieren
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $authCode
     * @param \wsdl\StructType\NeuerStatus[] $bestellstatus
     * @return string|bool
     */
    public function BestellstatusAktualisieren($authCode, array $bestellstatus)
    {
        try {
            $this->setResult($this->getSoapClient()->BestellstatusAktualisieren($authCode, $bestellstatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
