<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rechnungsadresse StructType
 * @subpackage Structs
 */
class Rechnungsadresse extends AbstractStructBase
{
    /**
     * The Adressenbezeichnung
     * @var string
     */
    public $Adressenbezeichnung;
    /**
     * The Firma
     * @var string
     */
    public $Firma;
    /**
     * The Firma2
     * @var string
     */
    public $Firma2;
    /**
     * The Firma3
     * @var string
     */
    public $Firma3;
    /**
     * The Anrede
     * @var string
     */
    public $Anrede;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Vorname
     * @var string
     */
    public $Vorname;
    /**
     * The Telefon
     * @var string
     */
    public $Telefon;
    /**
     * The Fax
     * @var string
     */
    public $Fax;
    /**
     * The Adresse1
     * @var string
     */
    public $Adresse1;
    /**
     * The Adresse2
     * @var string
     */
    public $Adresse2;
    /**
     * The Stadt
     * @var string
     */
    public $Stadt;
    /**
     * The Land
     * @var string
     */
    public $Land;
    /**
     * The PLZ
     * @var string
     */
    public $PLZ;
    /**
     * The EMail
     * @var string
     */
    public $EMail;
    /**
     * The UID
     * @var string
     */
    public $UID;
    /**
     * The Kundengruppe
     * @var int
     */
    public $Kundengruppe;
    /**
     * Constructor method for Rechnungsadresse
     * @uses Rechnungsadresse::setAdressenbezeichnung()
     * @uses Rechnungsadresse::setFirma()
     * @uses Rechnungsadresse::setFirma2()
     * @uses Rechnungsadresse::setFirma3()
     * @uses Rechnungsadresse::setAnrede()
     * @uses Rechnungsadresse::setName()
     * @uses Rechnungsadresse::setVorname()
     * @uses Rechnungsadresse::setTelefon()
     * @uses Rechnungsadresse::setFax()
     * @uses Rechnungsadresse::setAdresse1()
     * @uses Rechnungsadresse::setAdresse2()
     * @uses Rechnungsadresse::setStadt()
     * @uses Rechnungsadresse::setLand()
     * @uses Rechnungsadresse::setPLZ()
     * @uses Rechnungsadresse::setEMail()
     * @uses Rechnungsadresse::setUID()
     * @uses Rechnungsadresse::setKundengruppe()
     * @param string $adressenbezeichnung
     * @param string $firma
     * @param string $firma2
     * @param string $firma3
     * @param string $anrede
     * @param string $name
     * @param string $vorname
     * @param string $telefon
     * @param string $fax
     * @param string $adresse1
     * @param string $adresse2
     * @param string $stadt
     * @param string $land
     * @param string $pLZ
     * @param string $eMail
     * @param string $uID
     * @param int $kundengruppe
     */
    public function __construct($adressenbezeichnung = null, $firma = null, $firma2 = null, $firma3 = null, $anrede = null, $name = null, $vorname = null, $telefon = null, $fax = null, $adresse1 = null, $adresse2 = null, $stadt = null, $land = null, $pLZ = null, $eMail = null, $uID = null, $kundengruppe = null)
    {
        $this
            ->setAdressenbezeichnung($adressenbezeichnung)
            ->setFirma($firma)
            ->setFirma2($firma2)
            ->setFirma3($firma3)
            ->setAnrede($anrede)
            ->setName($name)
            ->setVorname($vorname)
            ->setTelefon($telefon)
            ->setFax($fax)
            ->setAdresse1($adresse1)
            ->setAdresse2($adresse2)
            ->setStadt($stadt)
            ->setLand($land)
            ->setPLZ($pLZ)
            ->setEMail($eMail)
            ->setUID($uID)
            ->setKundengruppe($kundengruppe);
    }
    /**
     * Get Adressenbezeichnung value
     * @return string|null
     */
    public function getAdressenbezeichnung()
    {
        return $this->Adressenbezeichnung;
    }
    /**
     * Set Adressenbezeichnung value
     * @param string $adressenbezeichnung
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setAdressenbezeichnung($adressenbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($adressenbezeichnung) && !is_string($adressenbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adressenbezeichnung, true), gettype($adressenbezeichnung)), __LINE__);
        }
        $this->Adressenbezeichnung = $adressenbezeichnung;
        return $this;
    }
    /**
     * Get Firma value
     * @return string|null
     */
    public function getFirma()
    {
        return $this->Firma;
    }
    /**
     * Set Firma value
     * @param string $firma
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setFirma($firma = null)
    {
        // validation for constraint: string
        if (!is_null($firma) && !is_string($firma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma, true), gettype($firma)), __LINE__);
        }
        $this->Firma = $firma;
        return $this;
    }
    /**
     * Get Firma2 value
     * @return string|null
     */
    public function getFirma2()
    {
        return $this->Firma2;
    }
    /**
     * Set Firma2 value
     * @param string $firma2
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setFirma2($firma2 = null)
    {
        // validation for constraint: string
        if (!is_null($firma2) && !is_string($firma2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma2, true), gettype($firma2)), __LINE__);
        }
        $this->Firma2 = $firma2;
        return $this;
    }
    /**
     * Get Firma3 value
     * @return string|null
     */
    public function getFirma3()
    {
        return $this->Firma3;
    }
    /**
     * Set Firma3 value
     * @param string $firma3
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setFirma3($firma3 = null)
    {
        // validation for constraint: string
        if (!is_null($firma3) && !is_string($firma3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma3, true), gettype($firma3)), __LINE__);
        }
        $this->Firma3 = $firma3;
        return $this;
    }
    /**
     * Get Anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->Anrede;
    }
    /**
     * Set Anrede value
     * @param string $anrede
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: string
        if (!is_null($anrede) && !is_string($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anrede, true), gettype($anrede)), __LINE__);
        }
        $this->Anrede = $anrede;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->Vorname;
    }
    /**
     * Set Vorname value
     * @param string $vorname
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->Vorname = $vorname;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Adresse1 value
     * @return string|null
     */
    public function getAdresse1()
    {
        return $this->Adresse1;
    }
    /**
     * Set Adresse1 value
     * @param string $adresse1
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setAdresse1($adresse1 = null)
    {
        // validation for constraint: string
        if (!is_null($adresse1) && !is_string($adresse1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse1, true), gettype($adresse1)), __LINE__);
        }
        $this->Adresse1 = $adresse1;
        return $this;
    }
    /**
     * Get Adresse2 value
     * @return string|null
     */
    public function getAdresse2()
    {
        return $this->Adresse2;
    }
    /**
     * Set Adresse2 value
     * @param string $adresse2
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setAdresse2($adresse2 = null)
    {
        // validation for constraint: string
        if (!is_null($adresse2) && !is_string($adresse2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse2, true), gettype($adresse2)), __LINE__);
        }
        $this->Adresse2 = $adresse2;
        return $this;
    }
    /**
     * Get Stadt value
     * @return string|null
     */
    public function getStadt()
    {
        return $this->Stadt;
    }
    /**
     * Set Stadt value
     * @param string $stadt
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setStadt($stadt = null)
    {
        // validation for constraint: string
        if (!is_null($stadt) && !is_string($stadt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stadt, true), gettype($stadt)), __LINE__);
        }
        $this->Stadt = $stadt;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @param string $land
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setLand($land = null)
    {
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($land, true), gettype($land)), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get PLZ value
     * @return string|null
     */
    public function getPLZ()
    {
        return $this->PLZ;
    }
    /**
     * Set PLZ value
     * @param string $pLZ
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setPLZ($pLZ = null)
    {
        // validation for constraint: string
        if (!is_null($pLZ) && !is_string($pLZ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pLZ, true), gettype($pLZ)), __LINE__);
        }
        $this->PLZ = $pLZ;
        return $this;
    }
    /**
     * Get EMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param string $eMail
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get UID value
     * @return string|null
     */
    public function getUID()
    {
        return $this->UID;
    }
    /**
     * Set UID value
     * @param string $uID
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setUID($uID = null)
    {
        // validation for constraint: string
        if (!is_null($uID) && !is_string($uID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uID, true), gettype($uID)), __LINE__);
        }
        $this->UID = $uID;
        return $this;
    }
    /**
     * Get Kundengruppe value
     * @return int|null
     */
    public function getKundengruppe()
    {
        return $this->Kundengruppe;
    }
    /**
     * Set Kundengruppe value
     * @param int $kundengruppe
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public function setKundengruppe($kundengruppe = null)
    {
        // validation for constraint: int
        if (!is_null($kundengruppe) && !(is_int($kundengruppe) || ctype_digit($kundengruppe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kundengruppe, true), gettype($kundengruppe)), __LINE__);
        }
        $this->Kundengruppe = $kundengruppe;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\Rechnungsadresse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
