<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Produkt StructType
 * @subpackage Structs
 */
class Produkt extends AbstractStructBase
{
    /**
     * The ArtNr
     * @var string
     */
    public $ArtNr;
    /**
     * The Veroeffentlicht
     * @var bool
     */
    public $Veroeffentlicht;
    /**
     * The KatID
     * @var int
     */
    public $KatID;
    /**
     * The Form
     * @var string
     */
    public $Form;
    /**
     * The Abmessungen
     * @var string
     */
    public $Abmessungen;
    /**
     * The Laenge
     * @var string
     */
    public $Laenge;
    /**
     * The Stueck
     * @var int
     */
    public $Stueck;
    /**
     * The Legierung
     * @var string
     */
    public $Legierung;
    /**
     * The PreisMeter
     * @var float
     */
    public $PreisMeter;
    /**
     * The SaegekostenStueck
     * @var float
     */
    public $SaegekostenStueck;
    /**
     * The Bemerkungen
     * @var string
     */
    public $Bemerkungen;
    /**
     * The KgMeter
     * @var float
     */
    public $KgMeter;
    /**
     * The EkOhneWmst
     * @var float
     */
    public $EkOhneWmst;
    /**
     * The VkOhneMwst
     * @var float
     */
    public $VkOhneMwst;
    /**
     * The Produkttext
     * @var string
     */
    public $Produkttext;
    /**
     * The Produkt_Bild_1
     * @var string
     */
    public $Produkt_Bild_1;
    /**
     * The Produkt_Bild_2
     * @var string
     */
    public $Produkt_Bild_2;
    /**
     * The StaffelGewicht1
     * @var float
     */
    public $StaffelGewicht1;
    /**
     * The StaffelGewicht2
     * @var float
     */
    public $StaffelGewicht2;
    /**
     * The StaffelGewicht3
     * @var float
     */
    public $StaffelGewicht3;
    /**
     * The StaffelPreis1
     * @var float
     */
    public $StaffelPreis1;
    /**
     * The StaffelPreis2
     * @var float
     */
    public $StaffelPreis2;
    /**
     * The StaffelPreis3
     * @var float
     */
    public $StaffelPreis3;
    /**
     * Constructor method for Produkt
     * @uses Produkt::setArtNr()
     * @uses Produkt::setVeroeffentlicht()
     * @uses Produkt::setKatID()
     * @uses Produkt::setForm()
     * @uses Produkt::setAbmessungen()
     * @uses Produkt::setLaenge()
     * @uses Produkt::setStueck()
     * @uses Produkt::setLegierung()
     * @uses Produkt::setPreisMeter()
     * @uses Produkt::setSaegekostenStueck()
     * @uses Produkt::setBemerkungen()
     * @uses Produkt::setKgMeter()
     * @uses Produkt::setEkOhneWmst()
     * @uses Produkt::setVkOhneMwst()
     * @uses Produkt::setProdukttext()
     * @uses Produkt::setProdukt_Bild_1()
     * @uses Produkt::setProdukt_Bild_2()
     * @uses Produkt::setStaffelGewicht1()
     * @uses Produkt::setStaffelGewicht2()
     * @uses Produkt::setStaffelGewicht3()
     * @uses Produkt::setStaffelPreis1()
     * @uses Produkt::setStaffelPreis2()
     * @uses Produkt::setStaffelPreis3()
     * @param string $artNr
     * @param bool $veroeffentlicht
     * @param int $katID
     * @param string $form
     * @param string $abmessungen
     * @param string $laenge
     * @param int $stueck
     * @param string $legierung
     * @param float $preisMeter
     * @param float $saegekostenStueck
     * @param string $bemerkungen
     * @param float $kgMeter
     * @param float $ekOhneWmst
     * @param float $vkOhneMwst
     * @param string $produkttext
     * @param string $produkt_Bild_1
     * @param string $produkt_Bild_2
     * @param float $staffelGewicht1
     * @param float $staffelGewicht2
     * @param float $staffelGewicht3
     * @param float $staffelPreis1
     * @param float $staffelPreis2
     * @param float $staffelPreis3
     */
    public function __construct($artNr = null, $veroeffentlicht = null, $katID = null, $form = null, $abmessungen = null, $laenge = null, $stueck = null, $legierung = null, $preisMeter = null, $saegekostenStueck = null, $bemerkungen = null, $kgMeter = null, $ekOhneWmst = null, $vkOhneMwst = null, $produkttext = null, $produkt_Bild_1 = null, $produkt_Bild_2 = null, $staffelGewicht1 = null, $staffelGewicht2 = null, $staffelGewicht3 = null, $staffelPreis1 = null, $staffelPreis2 = null, $staffelPreis3 = null)
    {
        $this
            ->setArtNr($artNr)
            ->setVeroeffentlicht($veroeffentlicht)
            ->setKatID($katID)
            ->setForm($form)
            ->setAbmessungen($abmessungen)
            ->setLaenge($laenge)
            ->setStueck($stueck)
            ->setLegierung($legierung)
            ->setPreisMeter($preisMeter)
            ->setSaegekostenStueck($saegekostenStueck)
            ->setBemerkungen($bemerkungen)
            ->setKgMeter($kgMeter)
            ->setEkOhneWmst($ekOhneWmst)
            ->setVkOhneMwst($vkOhneMwst)
            ->setProdukttext($produkttext)
            ->setProdukt_Bild_1($produkt_Bild_1)
            ->setProdukt_Bild_2($produkt_Bild_2)
            ->setStaffelGewicht1($staffelGewicht1)
            ->setStaffelGewicht2($staffelGewicht2)
            ->setStaffelGewicht3($staffelGewicht3)
            ->setStaffelPreis1($staffelPreis1)
            ->setStaffelPreis2($staffelPreis2)
            ->setStaffelPreis3($staffelPreis3);
    }
    /**
     * Get ArtNr value
     * @return string|null
     */
    public function getArtNr()
    {
        return $this->ArtNr;
    }
    /**
     * Set ArtNr value
     * @param string $artNr
     * @return \wsdl\StructType\Produkt
     */
    public function setArtNr($artNr = null)
    {
        // validation for constraint: string
        if (!is_null($artNr) && !is_string($artNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artNr, true), gettype($artNr)), __LINE__);
        }
        $this->ArtNr = $artNr;
        return $this;
    }
    /**
     * Get Veroeffentlicht value
     * @return bool|null
     */
    public function getVeroeffentlicht()
    {
        return $this->Veroeffentlicht;
    }
    /**
     * Set Veroeffentlicht value
     * @param bool $veroeffentlicht
     * @return \wsdl\StructType\Produkt
     */
    public function setVeroeffentlicht($veroeffentlicht = null)
    {
        // validation for constraint: boolean
        if (!is_null($veroeffentlicht) && !is_bool($veroeffentlicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($veroeffentlicht, true), gettype($veroeffentlicht)), __LINE__);
        }
        $this->Veroeffentlicht = $veroeffentlicht;
        return $this;
    }
    /**
     * Get KatID value
     * @return int|null
     */
    public function getKatID()
    {
        return $this->KatID;
    }
    /**
     * Set KatID value
     * @param int $katID
     * @return \wsdl\StructType\Produkt
     */
    public function setKatID($katID = null)
    {
        // validation for constraint: int
        if (!is_null($katID) && !(is_int($katID) || ctype_digit($katID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($katID, true), gettype($katID)), __LINE__);
        }
        $this->KatID = $katID;
        return $this;
    }
    /**
     * Get Form value
     * @return string|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param string $form
     * @return \wsdl\StructType\Produkt
     */
    public function setForm($form = null)
    {
        // validation for constraint: string
        if (!is_null($form) && !is_string($form)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($form, true), gettype($form)), __LINE__);
        }
        $this->Form = $form;
        return $this;
    }
    /**
     * Get Abmessungen value
     * @return string|null
     */
    public function getAbmessungen()
    {
        return $this->Abmessungen;
    }
    /**
     * Set Abmessungen value
     * @param string $abmessungen
     * @return \wsdl\StructType\Produkt
     */
    public function setAbmessungen($abmessungen = null)
    {
        // validation for constraint: string
        if (!is_null($abmessungen) && !is_string($abmessungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abmessungen, true), gettype($abmessungen)), __LINE__);
        }
        $this->Abmessungen = $abmessungen;
        return $this;
    }
    /**
     * Get Laenge value
     * @return string|null
     */
    public function getLaenge()
    {
        return $this->Laenge;
    }
    /**
     * Set Laenge value
     * @param string $laenge
     * @return \wsdl\StructType\Produkt
     */
    public function setLaenge($laenge = null)
    {
        // validation for constraint: string
        if (!is_null($laenge) && !is_string($laenge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laenge, true), gettype($laenge)), __LINE__);
        }
        $this->Laenge = $laenge;
        return $this;
    }
    /**
     * Get Stueck value
     * @return int|null
     */
    public function getStueck()
    {
        return $this->Stueck;
    }
    /**
     * Set Stueck value
     * @param int $stueck
     * @return \wsdl\StructType\Produkt
     */
    public function setStueck($stueck = null)
    {
        // validation for constraint: int
        if (!is_null($stueck) && !(is_int($stueck) || ctype_digit($stueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stueck, true), gettype($stueck)), __LINE__);
        }
        $this->Stueck = $stueck;
        return $this;
    }
    /**
     * Get Legierung value
     * @return string|null
     */
    public function getLegierung()
    {
        return $this->Legierung;
    }
    /**
     * Set Legierung value
     * @param string $legierung
     * @return \wsdl\StructType\Produkt
     */
    public function setLegierung($legierung = null)
    {
        // validation for constraint: string
        if (!is_null($legierung) && !is_string($legierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legierung, true), gettype($legierung)), __LINE__);
        }
        $this->Legierung = $legierung;
        return $this;
    }
    /**
     * Get PreisMeter value
     * @return float|null
     */
    public function getPreisMeter()
    {
        return $this->PreisMeter;
    }
    /**
     * Set PreisMeter value
     * @param float $preisMeter
     * @return \wsdl\StructType\Produkt
     */
    public function setPreisMeter($preisMeter = null)
    {
        // validation for constraint: float
        if (!is_null($preisMeter) && !(is_float($preisMeter) || is_numeric($preisMeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preisMeter, true), gettype($preisMeter)), __LINE__);
        }
        $this->PreisMeter = $preisMeter;
        return $this;
    }
    /**
     * Get SaegekostenStueck value
     * @return float|null
     */
    public function getSaegekostenStueck()
    {
        return $this->SaegekostenStueck;
    }
    /**
     * Set SaegekostenStueck value
     * @param float $saegekostenStueck
     * @return \wsdl\StructType\Produkt
     */
    public function setSaegekostenStueck($saegekostenStueck = null)
    {
        // validation for constraint: float
        if (!is_null($saegekostenStueck) && !(is_float($saegekostenStueck) || is_numeric($saegekostenStueck))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saegekostenStueck, true), gettype($saegekostenStueck)), __LINE__);
        }
        $this->SaegekostenStueck = $saegekostenStueck;
        return $this;
    }
    /**
     * Get Bemerkungen value
     * @return string|null
     */
    public function getBemerkungen()
    {
        return $this->Bemerkungen;
    }
    /**
     * Set Bemerkungen value
     * @param string $bemerkungen
     * @return \wsdl\StructType\Produkt
     */
    public function setBemerkungen($bemerkungen = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkungen) && !is_string($bemerkungen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkungen, true), gettype($bemerkungen)), __LINE__);
        }
        $this->Bemerkungen = $bemerkungen;
        return $this;
    }
    /**
     * Get KgMeter value
     * @return float|null
     */
    public function getKgMeter()
    {
        return $this->KgMeter;
    }
    /**
     * Set KgMeter value
     * @param float $kgMeter
     * @return \wsdl\StructType\Produkt
     */
    public function setKgMeter($kgMeter = null)
    {
        // validation for constraint: float
        if (!is_null($kgMeter) && !(is_float($kgMeter) || is_numeric($kgMeter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kgMeter, true), gettype($kgMeter)), __LINE__);
        }
        $this->KgMeter = $kgMeter;
        return $this;
    }
    /**
     * Get EkOhneWmst value
     * @return float|null
     */
    public function getEkOhneWmst()
    {
        return $this->EkOhneWmst;
    }
    /**
     * Set EkOhneWmst value
     * @param float $ekOhneWmst
     * @return \wsdl\StructType\Produkt
     */
    public function setEkOhneWmst($ekOhneWmst = null)
    {
        // validation for constraint: float
        if (!is_null($ekOhneWmst) && !(is_float($ekOhneWmst) || is_numeric($ekOhneWmst))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ekOhneWmst, true), gettype($ekOhneWmst)), __LINE__);
        }
        $this->EkOhneWmst = $ekOhneWmst;
        return $this;
    }
    /**
     * Get VkOhneMwst value
     * @return float|null
     */
    public function getVkOhneMwst()
    {
        return $this->VkOhneMwst;
    }
    /**
     * Set VkOhneMwst value
     * @param float $vkOhneMwst
     * @return \wsdl\StructType\Produkt
     */
    public function setVkOhneMwst($vkOhneMwst = null)
    {
        // validation for constraint: float
        if (!is_null($vkOhneMwst) && !(is_float($vkOhneMwst) || is_numeric($vkOhneMwst))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vkOhneMwst, true), gettype($vkOhneMwst)), __LINE__);
        }
        $this->VkOhneMwst = $vkOhneMwst;
        return $this;
    }
    /**
     * Get Produkttext value
     * @return string|null
     */
    public function getProdukttext()
    {
        return $this->Produkttext;
    }
    /**
     * Set Produkttext value
     * @param string $produkttext
     * @return \wsdl\StructType\Produkt
     */
    public function setProdukttext($produkttext = null)
    {
        // validation for constraint: string
        if (!is_null($produkttext) && !is_string($produkttext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkttext, true), gettype($produkttext)), __LINE__);
        }
        $this->Produkttext = $produkttext;
        return $this;
    }
    /**
     * Get produkt_Bild value
     * @return produkt_Bild
     */
    public function getProdukt_Bild_1()
    {
        return $this->Produkt_Bild_1;
    }
    /**
     * Set produkt_Bild value
     * @param produkt_Bild $produkt_Bild
     * @return \wsdl\StructType\Produkt
     */
    public function setProdukt_Bild_1($produkt_Bild_1 = null)
    {
        // validation for constraint: string
        if (!is_null($produkt_Bild_1) && !is_string($produkt_Bild_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkt_Bild_1, true), gettype($produkt_Bild_1)), __LINE__);
        }
        $this->Produkt_Bild_1 = $produkt_Bild_1;
        return $this;
    }
    /**
     * Get produkt_Bild value
     * @return produkt_Bild
     */
    public function getProdukt_Bild_2()
    {
        return $this->Produkt_Bild_2;
    }
    /**
     * Set produkt_Bild value
     * @param produkt_Bild $produkt_Bild
     * @return \wsdl\StructType\Produkt
     */
    public function setProdukt_Bild_2($produkt_Bild_2 = null)
    {
        // validation for constraint: string
        if (!is_null($produkt_Bild_2) && !is_string($produkt_Bild_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produkt_Bild_2, true), gettype($produkt_Bild_2)), __LINE__);
        }
        $this->Produkt_Bild_2 = $produkt_Bild_2;
        return $this;
    }
    /**
     * Get StaffelGewicht1 value
     * @return float|null
     */
    public function getStaffelGewicht1()
    {
        return $this->StaffelGewicht1;
    }
    /**
     * Set StaffelGewicht1 value
     * @param float $staffelGewicht1
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelGewicht1($staffelGewicht1 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelGewicht1) && !(is_float($staffelGewicht1) || is_numeric($staffelGewicht1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelGewicht1, true), gettype($staffelGewicht1)), __LINE__);
        }
        $this->StaffelGewicht1 = $staffelGewicht1;
        return $this;
    }
    /**
     * Get StaffelGewicht2 value
     * @return float|null
     */
    public function getStaffelGewicht2()
    {
        return $this->StaffelGewicht2;
    }
    /**
     * Set StaffelGewicht2 value
     * @param float $staffelGewicht2
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelGewicht2($staffelGewicht2 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelGewicht2) && !(is_float($staffelGewicht2) || is_numeric($staffelGewicht2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelGewicht2, true), gettype($staffelGewicht2)), __LINE__);
        }
        $this->StaffelGewicht2 = $staffelGewicht2;
        return $this;
    }
    /**
     * Get StaffelGewicht3 value
     * @return float|null
     */
    public function getStaffelGewicht3()
    {
        return $this->StaffelGewicht3;
    }
    /**
     * Set StaffelGewicht3 value
     * @param float $staffelGewicht3
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelGewicht3($staffelGewicht3 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelGewicht3) && !(is_float($staffelGewicht3) || is_numeric($staffelGewicht3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelGewicht3, true), gettype($staffelGewicht3)), __LINE__);
        }
        $this->StaffelGewicht3 = $staffelGewicht3;
        return $this;
    }
    /**
     * Get StaffelPreis1 value
     * @return float|null
     */
    public function getStaffelPreis1()
    {
        return $this->StaffelPreis1;
    }
    /**
     * Set StaffelPreis1 value
     * @param float $staffelPreis1
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelPreis1($staffelPreis1 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelPreis1) && !(is_float($staffelPreis1) || is_numeric($staffelPreis1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelPreis1, true), gettype($staffelPreis1)), __LINE__);
        }
        $this->StaffelPreis1 = $staffelPreis1;
        return $this;
    }
    /**
     * Get StaffelPreis2 value
     * @return float|null
     */
    public function getStaffelPreis2()
    {
        return $this->StaffelPreis2;
    }
    /**
     * Set StaffelPreis2 value
     * @param float $staffelPreis2
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelPreis2($staffelPreis2 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelPreis2) && !(is_float($staffelPreis2) || is_numeric($staffelPreis2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelPreis2, true), gettype($staffelPreis2)), __LINE__);
        }
        $this->StaffelPreis2 = $staffelPreis2;
        return $this;
    }
    /**
     * Get StaffelPreis3 value
     * @return float|null
     */
    public function getStaffelPreis3()
    {
        return $this->StaffelPreis3;
    }
    /**
     * Set StaffelPreis3 value
     * @param float $staffelPreis3
     * @return \wsdl\StructType\Produkt
     */
    public function setStaffelPreis3($staffelPreis3 = null)
    {
        // validation for constraint: float
        if (!is_null($staffelPreis3) && !(is_float($staffelPreis3) || is_numeric($staffelPreis3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($staffelPreis3, true), gettype($staffelPreis3)), __LINE__);
        }
        $this->StaffelPreis3 = $staffelPreis3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\Produkt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
