<?php

namespace wsdl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NeuerStatus StructType
 * @subpackage Structs
 */
class NeuerStatus extends AbstractStructBase
{
    /**
     * The Bestellnummer
     * @var int
     */
    public $Bestellnummer;
    /**
     * The Bestellstatus
     * @var string
     */
    public $Bestellstatus;
    /**
     * Constructor method for NeuerStatus
     * @uses NeuerStatus::setBestellnummer()
     * @uses NeuerStatus::setBestellstatus()
     * @param int $bestellnummer
     * @param string $bestellstatus
     */
    public function __construct($bestellnummer = null, $bestellstatus = null)
    {
        $this
            ->setBestellnummer($bestellnummer)
            ->setBestellstatus($bestellstatus);
    }
    /**
     * Get Bestellnummer value
     * @return int|null
     */
    public function getBestellnummer()
    {
        return $this->Bestellnummer;
    }
    /**
     * Set Bestellnummer value
     * @param int $bestellnummer
     * @return \wsdl\StructType\NeuerStatus
     */
    public function setBestellnummer($bestellnummer = null)
    {
        // validation for constraint: int
        if (!is_null($bestellnummer) && !(is_int($bestellnummer) || ctype_digit($bestellnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bestellnummer, true), gettype($bestellnummer)), __LINE__);
        }
        $this->Bestellnummer = $bestellnummer;
        return $this;
    }
    /**
     * Get Bestellstatus value
     * @return string|null
     */
    public function getBestellstatus()
    {
        return $this->Bestellstatus;
    }
    /**
     * Set Bestellstatus value
     * @param string $bestellstatus
     * @return \wsdl\StructType\NeuerStatus
     */
    public function setBestellstatus($bestellstatus = null)
    {
        // validation for constraint: string
        if (!is_null($bestellstatus) && !is_string($bestellstatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestellstatus, true), gettype($bestellstatus)), __LINE__);
        }
        $this->Bestellstatus = $bestellstatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \wsdl\StructType\NeuerStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
