<?php

namespace wsdl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bestellungen ServiceType
 * @subpackage Services
 */
class Bestellungen extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Bestellungen
     * Meta information extracted from the WSDL
     * - documentation: Bestellungen abholen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $authCode
     * @param string $zeit
     * @return \wsdl\StructType\Bestellung[]|bool
     */
    public function Bestellungen($authCode, $zeit)
    {
        try {
            $this->setResult($this->getSoapClient()->Bestellungen($authCode, $zeit));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \wsdl\StructType\Bestellung[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
