<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Shipping StructType
 * @subpackage Structs
 */
class Shipping extends AbstractStructBase
{
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The shipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipment;
    /**
     * The receiverAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressName
     */
    public $receiverAddress;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for Shipping
     * @uses Shipping::setWeight()
     * @uses Shipping::setShipment()
     * @uses Shipping::setReceiverAddress()
     * @uses Shipping::setReference()
     * @param float $weight
     * @param string $shipment
     * @param \StructType\AddressName $receiverAddress
     * @param string $reference
     */
    public function __construct($weight = null, $shipment = null, \StructType\AddressName $receiverAddress = null, $reference = null)
    {
        $this
            ->setWeight($weight)
            ->setShipment($shipment)
            ->setReceiverAddress($receiverAddress)
            ->setReference($reference);
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\Shipping
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get shipment value
     * @return string|null
     */
    public function getShipment()
    {
        return $this->shipment;
    }
    /**
     * Set shipment value
     * @param string $shipment
     * @return \StructType\Shipping
     */
    public function setShipment($shipment = null)
    {
        // validation for constraint: string
        if (!is_null($shipment) && !is_string($shipment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment, true), gettype($shipment)), __LINE__);
        }
        $this->shipment = $shipment;
        return $this;
    }
    /**
     * Get receiverAddress value
     * @return \StructType\AddressName|null
     */
    public function getReceiverAddress()
    {
        return $this->receiverAddress;
    }
    /**
     * Set receiverAddress value
     * @param \StructType\AddressName $receiverAddress
     * @return \StructType\Shipping
     */
    public function setReceiverAddress(\StructType\AddressName $receiverAddress = null)
    {
        $this->receiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\Shipping
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Shipping
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
