<?php

namespace EnumType;

/**
 * This class stands for eLabelType EnumType
 * @subpackage Enumerations
 */
class ELabelType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'PDF'
     * @return string 'PDF'
     */
    const VALUE_PDF = 'PDF';
    /**
     * Constant for value 'PDF_A6'
     * @return string 'PDF_A6'
     */
    const VALUE_PDF_A_6 = 'PDF_A6';
    /**
     * Constant for value 'ZPL'
     * @return string 'ZPL'
     */
    const VALUE_ZPL = 'ZPL';
    /**
     * Constant for value 'ZPL300'
     * @return string 'ZPL300'
     */
    const VALUE_ZPL_300 = 'ZPL300';
    /**
     * Constant for value 'EPL'
     * @return string 'EPL'
     */
    const VALUE_EPL = 'EPL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_PDF
     * @uses self::VALUE_PDF_A_6
     * @uses self::VALUE_ZPL
     * @uses self::VALUE_ZPL_300
     * @uses self::VALUE_EPL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_PDF,
            self::VALUE_PDF_A_6,
            self::VALUE_ZPL,
            self::VALUE_ZPL_300,
            self::VALUE_EPL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
