<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateNumberRangeRequest StructType
 * @subpackage Structs
 */
class TerminateNumberRangeRequest extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountryCode;
    /**
     * The ShippingCenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShippingCenterNumber;
    /**
     * The NumberRangeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberRangeFrom;
    /**
     * The NumberRangeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberRangeTo;
    /**
     * The CustomerCenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerCenterNumber;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerNumber;
    /**
     * The ClientID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * Constructor method for TerminateNumberRangeRequest
     * @uses TerminateNumberRangeRequest::setCountryCode()
     * @uses TerminateNumberRangeRequest::setShippingCenterNumber()
     * @uses TerminateNumberRangeRequest::setNumberRangeFrom()
     * @uses TerminateNumberRangeRequest::setNumberRangeTo()
     * @uses TerminateNumberRangeRequest::setCustomerCenterNumber()
     * @uses TerminateNumberRangeRequest::setCustomerNumber()
     * @uses TerminateNumberRangeRequest::setClientID()
     * @param int $countryCode
     * @param int $shippingCenterNumber
     * @param int $numberRangeFrom
     * @param int $numberRangeTo
     * @param int $customerCenterNumber
     * @param int $customerNumber
     * @param string $clientID
     */
    public function __construct($countryCode = null, $shippingCenterNumber = null, $numberRangeFrom = null, $numberRangeTo = null, $customerCenterNumber = null, $customerNumber = null, $clientID = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setShippingCenterNumber($shippingCenterNumber)
            ->setNumberRangeFrom($numberRangeFrom)
            ->setNumberRangeTo($numberRangeTo)
            ->setCustomerCenterNumber($customerCenterNumber)
            ->setCustomerNumber($customerNumber)
            ->setClientID($clientID);
    }
    /**
     * Get CountryCode value
     * @return int
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param int $countryCode
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: int
        if (!is_null($countryCode) && !(is_int($countryCode) || ctype_digit($countryCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ShippingCenterNumber value
     * @return int
     */
    public function getShippingCenterNumber()
    {
        return $this->ShippingCenterNumber;
    }
    /**
     * Set ShippingCenterNumber value
     * @param int $shippingCenterNumber
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setShippingCenterNumber($shippingCenterNumber = null)
    {
        // validation for constraint: int
        if (!is_null($shippingCenterNumber) && !(is_int($shippingCenterNumber) || ctype_digit($shippingCenterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingCenterNumber, true), gettype($shippingCenterNumber)), __LINE__);
        }
        $this->ShippingCenterNumber = $shippingCenterNumber;
        return $this;
    }
    /**
     * Get NumberRangeFrom value
     * @return int
     */
    public function getNumberRangeFrom()
    {
        return $this->NumberRangeFrom;
    }
    /**
     * Set NumberRangeFrom value
     * @param int $numberRangeFrom
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setNumberRangeFrom($numberRangeFrom = null)
    {
        // validation for constraint: int
        if (!is_null($numberRangeFrom) && !(is_int($numberRangeFrom) || ctype_digit($numberRangeFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberRangeFrom, true), gettype($numberRangeFrom)), __LINE__);
        }
        $this->NumberRangeFrom = $numberRangeFrom;
        return $this;
    }
    /**
     * Get NumberRangeTo value
     * @return int
     */
    public function getNumberRangeTo()
    {
        return $this->NumberRangeTo;
    }
    /**
     * Set NumberRangeTo value
     * @param int $numberRangeTo
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setNumberRangeTo($numberRangeTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberRangeTo) && !(is_int($numberRangeTo) || ctype_digit($numberRangeTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberRangeTo, true), gettype($numberRangeTo)), __LINE__);
        }
        $this->NumberRangeTo = $numberRangeTo;
        return $this;
    }
    /**
     * Get CustomerCenterNumber value
     * @return int
     */
    public function getCustomerCenterNumber()
    {
        return $this->CustomerCenterNumber;
    }
    /**
     * Set CustomerCenterNumber value
     * @param int $customerCenterNumber
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setCustomerCenterNumber($customerCenterNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerCenterNumber) && !(is_int($customerCenterNumber) || ctype_digit($customerCenterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCenterNumber, true), gettype($customerCenterNumber)), __LINE__);
        }
        $this->CustomerCenterNumber = $customerCenterNumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return int
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !(is_int($customerNumber) || ctype_digit($customerNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\TerminateNumberRangeRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminateNumberRangeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
