<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StdShipmentLabelRequest StructType
 * @subpackage Structs
 */
class StdShipmentLabelRequest extends StdShipmentRequest
{
    /**
     * The customLabelText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customLabelText;
    /**
     * The labelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LabelType
     */
    public $labelType;
    /**
     * The bic3data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Bic3LabelData
     */
    public $bic3data;
    /**
     * The overrideShipperLabelAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $overrideShipperLabelAddress;
    /**
     * The refnrasbarcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $refnrasbarcode;
    /**
     * Constructor method for StdShipmentLabelRequest
     * @uses StdShipmentLabelRequest::setCustomLabelText()
     * @uses StdShipmentLabelRequest::setLabelType()
     * @uses StdShipmentLabelRequest::setBic3data()
     * @uses StdShipmentLabelRequest::setOverrideShipperLabelAddress()
     * @uses StdShipmentLabelRequest::setRefnrasbarcode()
     * @param string $customLabelText
     * @param \StructType\LabelType $labelType
     * @param \StructType\Bic3LabelData $bic3data
     * @param \StructType\Address $overrideShipperLabelAddress
     * @param bool $refnrasbarcode
     */
    public function __construct($customLabelText = null, \StructType\LabelType $labelType = null, \StructType\Bic3LabelData $bic3data = null, \StructType\Address $overrideShipperLabelAddress = null, $refnrasbarcode = null)
    {
        $this
            ->setCustomLabelText($customLabelText)
            ->setLabelType($labelType)
            ->setBic3data($bic3data)
            ->setOverrideShipperLabelAddress($overrideShipperLabelAddress)
            ->setRefnrasbarcode($refnrasbarcode);
    }
    /**
     * Get customLabelText value
     * @return string|null
     */
    public function getCustomLabelText()
    {
        return $this->customLabelText;
    }
    /**
     * Set customLabelText value
     * @param string $customLabelText
     * @return \StructType\StdShipmentLabelRequest
     */
    public function setCustomLabelText($customLabelText = null)
    {
        // validation for constraint: string
        if (!is_null($customLabelText) && !is_string($customLabelText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customLabelText, true), gettype($customLabelText)), __LINE__);
        }
        $this->customLabelText = $customLabelText;
        return $this;
    }
    /**
     * Get labelType value
     * @return \StructType\LabelType|null
     */
    public function getLabelType()
    {
        return $this->labelType;
    }
    /**
     * Set labelType value
     * @param \StructType\LabelType $labelType
     * @return \StructType\StdShipmentLabelRequest
     */
    public function setLabelType(\StructType\LabelType $labelType = null)
    {
        $this->labelType = $labelType;
        return $this;
    }
    /**
     * Get bic3data value
     * @return \StructType\Bic3LabelData|null
     */
    public function getBic3data()
    {
        return $this->bic3data;
    }
    /**
     * Set bic3data value
     * @param \StructType\Bic3LabelData $bic3data
     * @return \StructType\StdShipmentLabelRequest
     */
    public function setBic3data(\StructType\Bic3LabelData $bic3data = null)
    {
        $this->bic3data = $bic3data;
        return $this;
    }
    /**
     * Get overrideShipperLabelAddress value
     * @return \StructType\Address|null
     */
    public function getOverrideShipperLabelAddress()
    {
        return $this->overrideShipperLabelAddress;
    }
    /**
     * Set overrideShipperLabelAddress value
     * @param \StructType\Address $overrideShipperLabelAddress
     * @return \StructType\StdShipmentLabelRequest
     */
    public function setOverrideShipperLabelAddress(\StructType\Address $overrideShipperLabelAddress = null)
    {
        $this->overrideShipperLabelAddress = $overrideShipperLabelAddress;
        return $this;
    }
    /**
     * Get refnrasbarcode value
     * @return bool|null
     */
    public function getRefnrasbarcode()
    {
        return $this->refnrasbarcode;
    }
    /**
     * Set refnrasbarcode value
     * @param bool $refnrasbarcode
     * @return \StructType\StdShipmentLabelRequest
     */
    public function setRefnrasbarcode($refnrasbarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($refnrasbarcode) && !is_bool($refnrasbarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refnrasbarcode, true), gettype($refnrasbarcode)), __LINE__);
        }
        $this->refnrasbarcode = $refnrasbarcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StdShipmentLabelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
