<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $serviceType;
    /**
     * The serviceAttr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $serviceAttr;
    /**
     * Constructor method for Service
     * @uses Service::setServiceType()
     * @uses Service::setServiceAttr()
     * @param int $serviceType
     * @param int $serviceAttr
     */
    public function __construct($serviceType = null, $serviceAttr = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setServiceAttr($serviceAttr);
    }
    /**
     * Get serviceType value
     * @return int
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param int $serviceType
     * @return \StructType\Service
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: int
        if (!is_null($serviceType) && !(is_int($serviceType) || ctype_digit($serviceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceAttr value
     * @return int
     */
    public function getServiceAttr()
    {
        return $this->serviceAttr;
    }
    /**
     * Set serviceAttr value
     * @param int $serviceAttr
     * @return \StructType\Service
     */
    public function setServiceAttr($serviceAttr = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAttr) && !(is_int($serviceAttr) || ctype_digit($serviceAttr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceAttr, true), gettype($serviceAttr)), __LINE__);
        }
        $this->serviceAttr = $serviceAttr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
