<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RdvShipmentData StructType
 * @subpackage Structs
 */
class RdvShipmentData extends AbstractStructBase
{
    /**
     * The ParcelOptional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ParcelOptional;
    /**
     * The SC_CenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SC_CenterNumber;
    /**
     * The RC_CenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RC_CenterNumber;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The NumberOfParcelsReal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfParcelsReal;
    /**
     * The CustomerRDVProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomerRDVProfile;
    /**
     * The RDVServiceAllowed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RDVServiceAllowed;
    /**
     * The Predict
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Predict;
    /**
     * The RdvUpdateable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RdvUpdateable;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParcelNumber;
    /**
     * The ShipmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentID;
    /**
     * The BIC3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BIC3;
    /**
     * The AvisDePassage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AvisDePassage;
    /**
     * The ShippingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDate;
    /**
     * The PredictCutOffDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PredictCutOffDate;
    /**
     * The ShipperName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShipperName;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RdvAddress
     */
    public $ReceiverAddress;
    /**
     * The ReceiverEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverEmailAddress;
    /**
     * The ReceiverAltZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAltZipCode;
    /**
     * The ShipperInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RdvDeliveryInfo
     */
    public $ShipperInfo;
    /**
     * The RdvInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RdvDeliveryInfo
     */
    public $RdvInfo;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRdvService
     */
    public $Services;
    /**
     * Constructor method for RdvShipmentData
     * @uses RdvShipmentData::setParcelOptional()
     * @uses RdvShipmentData::setSC_CenterNumber()
     * @uses RdvShipmentData::setRC_CenterNumber()
     * @uses RdvShipmentData::setWeight()
     * @uses RdvShipmentData::setNumberOfParcelsReal()
     * @uses RdvShipmentData::setCustomerRDVProfile()
     * @uses RdvShipmentData::setRDVServiceAllowed()
     * @uses RdvShipmentData::setPredict()
     * @uses RdvShipmentData::setRdvUpdateable()
     * @uses RdvShipmentData::setParcelNumber()
     * @uses RdvShipmentData::setShipmentID()
     * @uses RdvShipmentData::setBIC3()
     * @uses RdvShipmentData::setAvisDePassage()
     * @uses RdvShipmentData::setShippingDate()
     * @uses RdvShipmentData::setPredictCutOffDate()
     * @uses RdvShipmentData::setShipperName()
     * @uses RdvShipmentData::setReceiverAddress()
     * @uses RdvShipmentData::setReceiverEmailAddress()
     * @uses RdvShipmentData::setReceiverAltZipCode()
     * @uses RdvShipmentData::setShipperInfo()
     * @uses RdvShipmentData::setRdvInfo()
     * @uses RdvShipmentData::setServices()
     * @param bool $parcelOptional
     * @param int $sC_CenterNumber
     * @param int $rC_CenterNumber
     * @param float $weight
     * @param int $numberOfParcelsReal
     * @param bool $customerRDVProfile
     * @param bool $rDVServiceAllowed
     * @param bool $predict
     * @param bool $rdvUpdateable
     * @param string $parcelNumber
     * @param string $shipmentID
     * @param string $bIC3
     * @param string $avisDePassage
     * @param string $shippingDate
     * @param string $predictCutOffDate
     * @param string $shipperName
     * @param \StructType\RdvAddress $receiverAddress
     * @param string $receiverEmailAddress
     * @param string $receiverAltZipCode
     * @param \StructType\RdvDeliveryInfo $shipperInfo
     * @param \StructType\RdvDeliveryInfo $rdvInfo
     * @param \ArrayType\ArrayOfRdvService $services
     */
    public function __construct($parcelOptional = null, $sC_CenterNumber = null, $rC_CenterNumber = null, $weight = null, $numberOfParcelsReal = null, $customerRDVProfile = null, $rDVServiceAllowed = null, $predict = null, $rdvUpdateable = null, $parcelNumber = null, $shipmentID = null, $bIC3 = null, $avisDePassage = null, $shippingDate = null, $predictCutOffDate = null, $shipperName = null, \StructType\RdvAddress $receiverAddress = null, $receiverEmailAddress = null, $receiverAltZipCode = null, \StructType\RdvDeliveryInfo $shipperInfo = null, \StructType\RdvDeliveryInfo $rdvInfo = null, \ArrayType\ArrayOfRdvService $services = null)
    {
        $this
            ->setParcelOptional($parcelOptional)
            ->setSC_CenterNumber($sC_CenterNumber)
            ->setRC_CenterNumber($rC_CenterNumber)
            ->setWeight($weight)
            ->setNumberOfParcelsReal($numberOfParcelsReal)
            ->setCustomerRDVProfile($customerRDVProfile)
            ->setRDVServiceAllowed($rDVServiceAllowed)
            ->setPredict($predict)
            ->setRdvUpdateable($rdvUpdateable)
            ->setParcelNumber($parcelNumber)
            ->setShipmentID($shipmentID)
            ->setBIC3($bIC3)
            ->setAvisDePassage($avisDePassage)
            ->setShippingDate($shippingDate)
            ->setPredictCutOffDate($predictCutOffDate)
            ->setShipperName($shipperName)
            ->setReceiverAddress($receiverAddress)
            ->setReceiverEmailAddress($receiverEmailAddress)
            ->setReceiverAltZipCode($receiverAltZipCode)
            ->setShipperInfo($shipperInfo)
            ->setRdvInfo($rdvInfo)
            ->setServices($services);
    }
    /**
     * Get ParcelOptional value
     * @return bool
     */
    public function getParcelOptional()
    {
        return $this->ParcelOptional;
    }
    /**
     * Set ParcelOptional value
     * @param bool $parcelOptional
     * @return \StructType\RdvShipmentData
     */
    public function setParcelOptional($parcelOptional = null)
    {
        // validation for constraint: boolean
        if (!is_null($parcelOptional) && !is_bool($parcelOptional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parcelOptional, true), gettype($parcelOptional)), __LINE__);
        }
        $this->ParcelOptional = $parcelOptional;
        return $this;
    }
    /**
     * Get SC_CenterNumber value
     * @return int
     */
    public function getSC_CenterNumber()
    {
        return $this->SC_CenterNumber;
    }
    /**
     * Set SC_CenterNumber value
     * @param int $sC_CenterNumber
     * @return \StructType\RdvShipmentData
     */
    public function setSC_CenterNumber($sC_CenterNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sC_CenterNumber) && !(is_int($sC_CenterNumber) || ctype_digit($sC_CenterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sC_CenterNumber, true), gettype($sC_CenterNumber)), __LINE__);
        }
        $this->SC_CenterNumber = $sC_CenterNumber;
        return $this;
    }
    /**
     * Get RC_CenterNumber value
     * @return int
     */
    public function getRC_CenterNumber()
    {
        return $this->RC_CenterNumber;
    }
    /**
     * Set RC_CenterNumber value
     * @param int $rC_CenterNumber
     * @return \StructType\RdvShipmentData
     */
    public function setRC_CenterNumber($rC_CenterNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rC_CenterNumber) && !(is_int($rC_CenterNumber) || ctype_digit($rC_CenterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rC_CenterNumber, true), gettype($rC_CenterNumber)), __LINE__);
        }
        $this->RC_CenterNumber = $rC_CenterNumber;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\RdvShipmentData
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get NumberOfParcelsReal value
     * @return int
     */
    public function getNumberOfParcelsReal()
    {
        return $this->NumberOfParcelsReal;
    }
    /**
     * Set NumberOfParcelsReal value
     * @param int $numberOfParcelsReal
     * @return \StructType\RdvShipmentData
     */
    public function setNumberOfParcelsReal($numberOfParcelsReal = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfParcelsReal) && !(is_int($numberOfParcelsReal) || ctype_digit($numberOfParcelsReal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfParcelsReal, true), gettype($numberOfParcelsReal)), __LINE__);
        }
        $this->NumberOfParcelsReal = $numberOfParcelsReal;
        return $this;
    }
    /**
     * Get CustomerRDVProfile value
     * @return bool
     */
    public function getCustomerRDVProfile()
    {
        return $this->CustomerRDVProfile;
    }
    /**
     * Set CustomerRDVProfile value
     * @param bool $customerRDVProfile
     * @return \StructType\RdvShipmentData
     */
    public function setCustomerRDVProfile($customerRDVProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerRDVProfile) && !is_bool($customerRDVProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerRDVProfile, true), gettype($customerRDVProfile)), __LINE__);
        }
        $this->CustomerRDVProfile = $customerRDVProfile;
        return $this;
    }
    /**
     * Get RDVServiceAllowed value
     * @return bool
     */
    public function getRDVServiceAllowed()
    {
        return $this->RDVServiceAllowed;
    }
    /**
     * Set RDVServiceAllowed value
     * @param bool $rDVServiceAllowed
     * @return \StructType\RdvShipmentData
     */
    public function setRDVServiceAllowed($rDVServiceAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($rDVServiceAllowed) && !is_bool($rDVServiceAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rDVServiceAllowed, true), gettype($rDVServiceAllowed)), __LINE__);
        }
        $this->RDVServiceAllowed = $rDVServiceAllowed;
        return $this;
    }
    /**
     * Get Predict value
     * @return bool
     */
    public function getPredict()
    {
        return $this->Predict;
    }
    /**
     * Set Predict value
     * @param bool $predict
     * @return \StructType\RdvShipmentData
     */
    public function setPredict($predict = null)
    {
        // validation for constraint: boolean
        if (!is_null($predict) && !is_bool($predict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($predict, true), gettype($predict)), __LINE__);
        }
        $this->Predict = $predict;
        return $this;
    }
    /**
     * Get RdvUpdateable value
     * @return bool
     */
    public function getRdvUpdateable()
    {
        return $this->RdvUpdateable;
    }
    /**
     * Set RdvUpdateable value
     * @param bool $rdvUpdateable
     * @return \StructType\RdvShipmentData
     */
    public function setRdvUpdateable($rdvUpdateable = null)
    {
        // validation for constraint: boolean
        if (!is_null($rdvUpdateable) && !is_bool($rdvUpdateable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rdvUpdateable, true), gettype($rdvUpdateable)), __LINE__);
        }
        $this->RdvUpdateable = $rdvUpdateable;
        return $this;
    }
    /**
     * Get ParcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param string $parcelNumber
     * @return \StructType\RdvShipmentData
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ShipmentID value
     * @return string|null
     */
    public function getShipmentID()
    {
        return $this->ShipmentID;
    }
    /**
     * Set ShipmentID value
     * @param string $shipmentID
     * @return \StructType\RdvShipmentData
     */
    public function setShipmentID($shipmentID = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentID) && !is_string($shipmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentID, true), gettype($shipmentID)), __LINE__);
        }
        $this->ShipmentID = $shipmentID;
        return $this;
    }
    /**
     * Get BIC3 value
     * @return string|null
     */
    public function getBIC3()
    {
        return $this->BIC3;
    }
    /**
     * Set BIC3 value
     * @param string $bIC3
     * @return \StructType\RdvShipmentData
     */
    public function setBIC3($bIC3 = null)
    {
        // validation for constraint: string
        if (!is_null($bIC3) && !is_string($bIC3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC3, true), gettype($bIC3)), __LINE__);
        }
        $this->BIC3 = $bIC3;
        return $this;
    }
    /**
     * Get AvisDePassage value
     * @return string|null
     */
    public function getAvisDePassage()
    {
        return $this->AvisDePassage;
    }
    /**
     * Set AvisDePassage value
     * @param string $avisDePassage
     * @return \StructType\RdvShipmentData
     */
    public function setAvisDePassage($avisDePassage = null)
    {
        // validation for constraint: string
        if (!is_null($avisDePassage) && !is_string($avisDePassage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avisDePassage, true), gettype($avisDePassage)), __LINE__);
        }
        $this->AvisDePassage = $avisDePassage;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \StructType\RdvShipmentData
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get PredictCutOffDate value
     * @return string|null
     */
    public function getPredictCutOffDate()
    {
        return $this->PredictCutOffDate;
    }
    /**
     * Set PredictCutOffDate value
     * @param string $predictCutOffDate
     * @return \StructType\RdvShipmentData
     */
    public function setPredictCutOffDate($predictCutOffDate = null)
    {
        // validation for constraint: string
        if (!is_null($predictCutOffDate) && !is_string($predictCutOffDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($predictCutOffDate, true), gettype($predictCutOffDate)), __LINE__);
        }
        $this->PredictCutOffDate = $predictCutOffDate;
        return $this;
    }
    /**
     * Get ShipperName value
     * @return string|null
     */
    public function getShipperName()
    {
        return $this->ShipperName;
    }
    /**
     * Set ShipperName value
     * @param string $shipperName
     * @return \StructType\RdvShipmentData
     */
    public function setShipperName($shipperName = null)
    {
        // validation for constraint: string
        if (!is_null($shipperName) && !is_string($shipperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperName, true), gettype($shipperName)), __LINE__);
        }
        $this->ShipperName = $shipperName;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return \StructType\RdvAddress|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param \StructType\RdvAddress $receiverAddress
     * @return \StructType\RdvShipmentData
     */
    public function setReceiverAddress(\StructType\RdvAddress $receiverAddress = null)
    {
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get ReceiverEmailAddress value
     * @return string|null
     */
    public function getReceiverEmailAddress()
    {
        return $this->ReceiverEmailAddress;
    }
    /**
     * Set ReceiverEmailAddress value
     * @param string $receiverEmailAddress
     * @return \StructType\RdvShipmentData
     */
    public function setReceiverEmailAddress($receiverEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverEmailAddress) && !is_string($receiverEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverEmailAddress, true), gettype($receiverEmailAddress)), __LINE__);
        }
        $this->ReceiverEmailAddress = $receiverEmailAddress;
        return $this;
    }
    /**
     * Get ReceiverAltZipCode value
     * @return string|null
     */
    public function getReceiverAltZipCode()
    {
        return $this->ReceiverAltZipCode;
    }
    /**
     * Set ReceiverAltZipCode value
     * @param string $receiverAltZipCode
     * @return \StructType\RdvShipmentData
     */
    public function setReceiverAltZipCode($receiverAltZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAltZipCode) && !is_string($receiverAltZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAltZipCode, true), gettype($receiverAltZipCode)), __LINE__);
        }
        $this->ReceiverAltZipCode = $receiverAltZipCode;
        return $this;
    }
    /**
     * Get ShipperInfo value
     * @return \StructType\RdvDeliveryInfo|null
     */
    public function getShipperInfo()
    {
        return $this->ShipperInfo;
    }
    /**
     * Set ShipperInfo value
     * @param \StructType\RdvDeliveryInfo $shipperInfo
     * @return \StructType\RdvShipmentData
     */
    public function setShipperInfo(\StructType\RdvDeliveryInfo $shipperInfo = null)
    {
        $this->ShipperInfo = $shipperInfo;
        return $this;
    }
    /**
     * Get RdvInfo value
     * @return \StructType\RdvDeliveryInfo|null
     */
    public function getRdvInfo()
    {
        return $this->RdvInfo;
    }
    /**
     * Set RdvInfo value
     * @param \StructType\RdvDeliveryInfo $rdvInfo
     * @return \StructType\RdvShipmentData
     */
    public function setRdvInfo(\StructType\RdvDeliveryInfo $rdvInfo = null)
    {
        $this->RdvInfo = $rdvInfo;
        return $this;
    }
    /**
     * Get Services value
     * @return \ArrayType\ArrayOfRdvService|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \ArrayType\ArrayOfRdvService $services
     * @return \StructType\RdvShipmentData
     */
    public function setServices(\ArrayType\ArrayOfRdvService $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RdvShipmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
