<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupAtCustomerRequest StructType
 * @subpackage Structs
 */
class PickupAtCustomerRequest extends AbstractStructBase
{
    /**
     * The shipperaddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shipperaddress;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The pick_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pick_date;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PickupData
     */
    public $data;
    /**
     * The shipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParcel
     */
    public $shipments;
    /**
     * Constructor method for PickupAtCustomerRequest
     * @uses PickupAtCustomerRequest::setShipperaddress()
     * @uses PickupAtCustomerRequest::setCustomer()
     * @uses PickupAtCustomerRequest::setPick_date()
     * @uses PickupAtCustomerRequest::setData()
     * @uses PickupAtCustomerRequest::setShipments()
     * @param \StructType\Address $shipperaddress
     * @param \StructType\Customer $customer
     * @param string $pick_date
     * @param \StructType\PickupData $data
     * @param \ArrayType\ArrayOfParcel $shipments
     */
    public function __construct(\StructType\Address $shipperaddress = null, \StructType\Customer $customer = null, $pick_date = null, \StructType\PickupData $data = null, \ArrayType\ArrayOfParcel $shipments = null)
    {
        $this
            ->setShipperaddress($shipperaddress)
            ->setCustomer($customer)
            ->setPick_date($pick_date)
            ->setData($data)
            ->setShipments($shipments);
    }
    /**
     * Get shipperaddress value
     * @return \StructType\Address|null
     */
    public function getShipperaddress()
    {
        return $this->shipperaddress;
    }
    /**
     * Set shipperaddress value
     * @param \StructType\Address $shipperaddress
     * @return \StructType\PickupAtCustomerRequest
     */
    public function setShipperaddress(\StructType\Address $shipperaddress = null)
    {
        $this->shipperaddress = $shipperaddress;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\PickupAtCustomerRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get pick_date value
     * @return string|null
     */
    public function getPick_date()
    {
        return $this->pick_date;
    }
    /**
     * Set pick_date value
     * @param string $pick_date
     * @return \StructType\PickupAtCustomerRequest
     */
    public function setPick_date($pick_date = null)
    {
        // validation for constraint: string
        if (!is_null($pick_date) && !is_string($pick_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pick_date, true), gettype($pick_date)), __LINE__);
        }
        $this->pick_date = $pick_date;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\PickupData|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \StructType\PickupData $data
     * @return \StructType\PickupAtCustomerRequest
     */
    public function setData(\StructType\PickupData $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get shipments value
     * @return \ArrayType\ArrayOfParcel|null
     */
    public function getShipments()
    {
        return $this->shipments;
    }
    /**
     * Set shipments value
     * @param \ArrayType\ArrayOfParcel $shipments
     * @return \StructType\PickupAtCustomerRequest
     */
    public function setShipments(\ArrayType\ArrayOfParcel $shipments = null)
    {
        $this->shipments = $shipments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PickupAtCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
