<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberRangeRequest StructType
 * @subpackage Structs
 */
class NumberRangeRequest extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountryCode;
    /**
     * The CustomerCenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerCenterNumber;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerNumber;
    /**
     * The ShippingCenterNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShippingCenterNumber;
    /**
     * The NumberRangeFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberRangeFrom;
    /**
     * The NumberRangeTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberRangeTo;
    /**
     * The NumberRangeFree
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberRangeFree;
    /**
     * The ClientID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientID;
    /**
     * The NumberRangeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberRangeType;
    /**
     * The NumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberType;
    /**
     * Constructor method for NumberRangeRequest
     * @uses NumberRangeRequest::setCountryCode()
     * @uses NumberRangeRequest::setCustomerCenterNumber()
     * @uses NumberRangeRequest::setCustomerNumber()
     * @uses NumberRangeRequest::setShippingCenterNumber()
     * @uses NumberRangeRequest::setNumberRangeFrom()
     * @uses NumberRangeRequest::setNumberRangeTo()
     * @uses NumberRangeRequest::setNumberRangeFree()
     * @uses NumberRangeRequest::setClientID()
     * @uses NumberRangeRequest::setNumberRangeType()
     * @uses NumberRangeRequest::setNumberType()
     * @param int $countryCode
     * @param int $customerCenterNumber
     * @param int $customerNumber
     * @param string $shippingCenterNumber
     * @param string $numberRangeFrom
     * @param string $numberRangeTo
     * @param string $numberRangeFree
     * @param string $clientID
     * @param string $numberRangeType
     * @param string $numberType
     */
    public function __construct($countryCode = null, $customerCenterNumber = null, $customerNumber = null, $shippingCenterNumber = null, $numberRangeFrom = null, $numberRangeTo = null, $numberRangeFree = null, $clientID = null, $numberRangeType = null, $numberType = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setCustomerCenterNumber($customerCenterNumber)
            ->setCustomerNumber($customerNumber)
            ->setShippingCenterNumber($shippingCenterNumber)
            ->setNumberRangeFrom($numberRangeFrom)
            ->setNumberRangeTo($numberRangeTo)
            ->setNumberRangeFree($numberRangeFree)
            ->setClientID($clientID)
            ->setNumberRangeType($numberRangeType)
            ->setNumberType($numberType);
    }
    /**
     * Get CountryCode value
     * @return int
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param int $countryCode
     * @return \StructType\NumberRangeRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: int
        if (!is_null($countryCode) && !(is_int($countryCode) || ctype_digit($countryCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CustomerCenterNumber value
     * @return int
     */
    public function getCustomerCenterNumber()
    {
        return $this->CustomerCenterNumber;
    }
    /**
     * Set CustomerCenterNumber value
     * @param int $customerCenterNumber
     * @return \StructType\NumberRangeRequest
     */
    public function setCustomerCenterNumber($customerCenterNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerCenterNumber) && !(is_int($customerCenterNumber) || ctype_digit($customerCenterNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCenterNumber, true), gettype($customerCenterNumber)), __LINE__);
        }
        $this->CustomerCenterNumber = $customerCenterNumber;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return int
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param int $customerNumber
     * @return \StructType\NumberRangeRequest
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($customerNumber) && !(is_int($customerNumber) || ctype_digit($customerNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get ShippingCenterNumber value
     * @return string|null
     */
    public function getShippingCenterNumber()
    {
        return $this->ShippingCenterNumber;
    }
    /**
     * Set ShippingCenterNumber value
     * @param string $shippingCenterNumber
     * @return \StructType\NumberRangeRequest
     */
    public function setShippingCenterNumber($shippingCenterNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shippingCenterNumber) && !is_string($shippingCenterNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingCenterNumber, true), gettype($shippingCenterNumber)), __LINE__);
        }
        $this->ShippingCenterNumber = $shippingCenterNumber;
        return $this;
    }
    /**
     * Get NumberRangeFrom value
     * @return string|null
     */
    public function getNumberRangeFrom()
    {
        return $this->NumberRangeFrom;
    }
    /**
     * Set NumberRangeFrom value
     * @param string $numberRangeFrom
     * @return \StructType\NumberRangeRequest
     */
    public function setNumberRangeFrom($numberRangeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeFrom) && !is_string($numberRangeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRangeFrom, true), gettype($numberRangeFrom)), __LINE__);
        }
        $this->NumberRangeFrom = $numberRangeFrom;
        return $this;
    }
    /**
     * Get NumberRangeTo value
     * @return string|null
     */
    public function getNumberRangeTo()
    {
        return $this->NumberRangeTo;
    }
    /**
     * Set NumberRangeTo value
     * @param string $numberRangeTo
     * @return \StructType\NumberRangeRequest
     */
    public function setNumberRangeTo($numberRangeTo = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeTo) && !is_string($numberRangeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRangeTo, true), gettype($numberRangeTo)), __LINE__);
        }
        $this->NumberRangeTo = $numberRangeTo;
        return $this;
    }
    /**
     * Get NumberRangeFree value
     * @return string|null
     */
    public function getNumberRangeFree()
    {
        return $this->NumberRangeFree;
    }
    /**
     * Set NumberRangeFree value
     * @param string $numberRangeFree
     * @return \StructType\NumberRangeRequest
     */
    public function setNumberRangeFree($numberRangeFree = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeFree) && !is_string($numberRangeFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRangeFree, true), gettype($numberRangeFree)), __LINE__);
        }
        $this->NumberRangeFree = $numberRangeFree;
        return $this;
    }
    /**
     * Get ClientID value
     * @return string|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param string $clientID
     * @return \StructType\NumberRangeRequest
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: string
        if (!is_null($clientID) && !is_string($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get NumberRangeType value
     * @return string|null
     */
    public function getNumberRangeType()
    {
        return $this->NumberRangeType;
    }
    /**
     * Set NumberRangeType value
     * @param string $numberRangeType
     * @return \StructType\NumberRangeRequest
     */
    public function setNumberRangeType($numberRangeType = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeType) && !is_string($numberRangeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberRangeType, true), gettype($numberRangeType)), __LINE__);
        }
        $this->NumberRangeType = $numberRangeType;
        return $this;
    }
    /**
     * Get NumberType value
     * @return string|null
     */
    public function getNumberType()
    {
        return $this->NumberType;
    }
    /**
     * Set NumberType value
     * @param string $numberType
     * @return \StructType\NumberRangeRequest
     */
    public function setNumberType($numberType = null)
    {
        // validation for constraint: string
        if (!is_null($numberType) && !is_string($numberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberType, true), gettype($numberType)), __LINE__);
        }
        $this->NumberType = $numberType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NumberRangeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
