<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoRoutingDataRequest StructType
 * @subpackage Structs
 */
class GeoRoutingDataRequest extends GeoRoutingBaseRequest
{
    /**
     * The dimUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dimUnit;
    /**
     * The dimCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $dimCount;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfService
     */
    public $services;
    /**
     * Constructor method for GeoRoutingDataRequest
     * @uses GeoRoutingDataRequest::setDimUnit()
     * @uses GeoRoutingDataRequest::setDimCount()
     * @uses GeoRoutingDataRequest::setWeight()
     * @uses GeoRoutingDataRequest::setServices()
     * @param int $dimUnit
     * @param float $dimCount
     * @param float $weight
     * @param \ArrayType\ArrayOfService $services
     */
    public function __construct($dimUnit = null, $dimCount = null, $weight = null, \ArrayType\ArrayOfService $services = null)
    {
        $this
            ->setDimUnit($dimUnit)
            ->setDimCount($dimCount)
            ->setWeight($weight)
            ->setServices($services);
    }
    /**
     * Get dimUnit value
     * @return int
     */
    public function getDimUnit()
    {
        return $this->dimUnit;
    }
    /**
     * Set dimUnit value
     * @param int $dimUnit
     * @return \StructType\GeoRoutingDataRequest
     */
    public function setDimUnit($dimUnit = null)
    {
        // validation for constraint: int
        if (!is_null($dimUnit) && !(is_int($dimUnit) || ctype_digit($dimUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dimUnit, true), gettype($dimUnit)), __LINE__);
        }
        $this->dimUnit = $dimUnit;
        return $this;
    }
    /**
     * Get dimCount value
     * @return float
     */
    public function getDimCount()
    {
        return $this->dimCount;
    }
    /**
     * Set dimCount value
     * @param float $dimCount
     * @return \StructType\GeoRoutingDataRequest
     */
    public function setDimCount($dimCount = null)
    {
        // validation for constraint: float
        if (!is_null($dimCount) && !(is_float($dimCount) || is_numeric($dimCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dimCount, true), gettype($dimCount)), __LINE__);
        }
        $this->dimCount = $dimCount;
        return $this;
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\GeoRoutingDataRequest
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get services value
     * @return \ArrayType\ArrayOfService|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \ArrayType\ArrayOfService $services
     * @return \StructType\GeoRoutingDataRequest
     */
    public function setServices(\ArrayType\ArrayOfService $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoRoutingDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
