<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entry StructType
 * @subpackage Structs
 */
class Entry extends AbstractStructBase
{
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countrycode;
    /**
     * The centernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $centernumber;
    /**
     * The first_parcelnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $first_parcelnumber;
    /**
     * The last_parcelnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $last_parcelnumber;
    /**
     * Constructor method for Entry
     * @uses Entry::setCountrycode()
     * @uses Entry::setCenternumber()
     * @uses Entry::setFirst_parcelnumber()
     * @uses Entry::setLast_parcelnumber()
     * @param int $countrycode
     * @param int $centernumber
     * @param int $first_parcelnumber
     * @param int $last_parcelnumber
     */
    public function __construct($countrycode = null, $centernumber = null, $first_parcelnumber = null, $last_parcelnumber = null)
    {
        $this
            ->setCountrycode($countrycode)
            ->setCenternumber($centernumber)
            ->setFirst_parcelnumber($first_parcelnumber)
            ->setLast_parcelnumber($last_parcelnumber);
    }
    /**
     * Get countrycode value
     * @return int
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param int $countrycode
     * @return \StructType\Entry
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: int
        if (!is_null($countrycode) && !(is_int($countrycode) || ctype_digit($countrycode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get centernumber value
     * @return int
     */
    public function getCenternumber()
    {
        return $this->centernumber;
    }
    /**
     * Set centernumber value
     * @param int $centernumber
     * @return \StructType\Entry
     */
    public function setCenternumber($centernumber = null)
    {
        // validation for constraint: int
        if (!is_null($centernumber) && !(is_int($centernumber) || ctype_digit($centernumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($centernumber, true), gettype($centernumber)), __LINE__);
        }
        $this->centernumber = $centernumber;
        return $this;
    }
    /**
     * Get first_parcelnumber value
     * @return int
     */
    public function getFirst_parcelnumber()
    {
        return $this->first_parcelnumber;
    }
    /**
     * Set first_parcelnumber value
     * @param int $first_parcelnumber
     * @return \StructType\Entry
     */
    public function setFirst_parcelnumber($first_parcelnumber = null)
    {
        // validation for constraint: int
        if (!is_null($first_parcelnumber) && !(is_int($first_parcelnumber) || ctype_digit($first_parcelnumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($first_parcelnumber, true), gettype($first_parcelnumber)), __LINE__);
        }
        $this->first_parcelnumber = $first_parcelnumber;
        return $this;
    }
    /**
     * Get last_parcelnumber value
     * @return int
     */
    public function getLast_parcelnumber()
    {
        return $this->last_parcelnumber;
    }
    /**
     * Set last_parcelnumber value
     * @param int $last_parcelnumber
     * @return \StructType\Entry
     */
    public function setLast_parcelnumber($last_parcelnumber = null)
    {
        // validation for constraint: int
        if (!is_null($last_parcelnumber) && !(is_int($last_parcelnumber) || ctype_digit($last_parcelnumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($last_parcelnumber, true), gettype($last_parcelnumber)), __LINE__);
        }
        $this->last_parcelnumber = $last_parcelnumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Entry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
