<?php

namespace EnumType;

/**
 * This class stands for TransitTimeType EnumType
 * @subpackage Enumerations
 */
class TransitTimeType
{
    /**
     * Constant for value 'TransitTime_Default'
     * @return string 'TransitTime_Default'
     */
    const VALUE_TRANSIT_TIME_DEFAULT = 'TransitTime_Default';
    /**
     * Constant for value 'TransitTime_Predict'
     * @return string 'TransitTime_Predict'
     */
    const VALUE_TRANSIT_TIME_PREDICT = 'TransitTime_Predict';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSIT_TIME_DEFAULT
     * @uses self::VALUE_TRANSIT_TIME_PREDICT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSIT_TIME_DEFAULT,
            self::VALUE_TRANSIT_TIME_PREDICT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
