<?php

namespace EnumType;

/**
 * This class stands for ServiceNoticeType EnumType
 * @subpackage Enumerations
 */
class ServiceNoticeType
{
    /**
     * Constant for value 'pick'
     * @return string 'pick'
     */
    const VALUE_PICK = 'pick';
    /**
     * Constant for value 'dely'
     * @return string 'dely'
     */
    const VALUE_DELY = 'dely';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PICK
     * @uses self::VALUE_DELY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PICK,
            self::VALUE_DELY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
