<?php

namespace EnumType;

/**
 * This class stands for RdvShipmentDataSearchMode EnumType
 * @subpackage Enumerations
 */
class RdvShipmentDataSearchMode
{
    /**
     * Constant for value 'SearchByParcelNumber'
     * @return string 'SearchByParcelNumber'
     */
    const VALUE_SEARCH_BY_PARCEL_NUMBER = 'SearchByParcelNumber';
    /**
     * Constant for value 'SearchByAvisDePassage'
     * @return string 'SearchByAvisDePassage'
     */
    const VALUE_SEARCH_BY_AVIS_DE_PASSAGE = 'SearchByAvisDePassage';
    /**
     * Constant for value 'SearchByToken'
     * @return string 'SearchByToken'
     */
    const VALUE_SEARCH_BY_TOKEN = 'SearchByToken';
    /**
     * Constant for value 'SearchByBIC3'
     * @return string 'SearchByBIC3'
     */
    const VALUE_SEARCH_BY_BIC_3 = 'SearchByBIC3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEARCH_BY_PARCEL_NUMBER
     * @uses self::VALUE_SEARCH_BY_AVIS_DE_PASSAGE
     * @uses self::VALUE_SEARCH_BY_TOKEN
     * @uses self::VALUE_SEARCH_BY_BIC_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEARCH_BY_PARCEL_NUMBER,
            self::VALUE_SEARCH_BY_AVIS_DE_PASSAGE,
            self::VALUE_SEARCH_BY_TOKEN,
            self::VALUE_SEARCH_BY_BIC_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
