<?php

namespace EnumType;

/**
 * This class stands for etypeInsurance EnumType
 * @subpackage Enumerations
 */
class EtypeInsurance
{
    /**
     * Constant for value 'byShipments'
     * @return string 'byShipments'
     */
    const VALUE_BY_SHIPMENTS = 'byShipments';
    /**
     * Constant for value 'byWeight'
     * @return string 'byWeight'
     */
    const VALUE_BY_WEIGHT = 'byWeight';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BY_SHIPMENTS
     * @uses self::VALUE_BY_WEIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BY_SHIPMENTS,
            self::VALUE_BY_WEIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
