<?php

namespace EnumType;

/**
 * This class stands for etypeContact EnumType
 * @subpackage Enumerations
 */
class EtypeContact
{
    /**
     * Constant for value 'No'
     * @return string 'No'
     */
    const VALUE_NO = 'No';
    /**
     * Constant for value 'Predict'
     * @return string 'Predict'
     */
    const VALUE_PREDICT = 'Predict';
    /**
     * Constant for value 'AutomaticSMS'
     * @return string 'AutomaticSMS'
     */
    const VALUE_AUTOMATIC_SMS = 'AutomaticSMS';
    /**
     * Constant for value 'AutomaticMail'
     * @return string 'AutomaticMail'
     */
    const VALUE_AUTOMATIC_MAIL = 'AutomaticMail';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO
     * @uses self::VALUE_PREDICT
     * @uses self::VALUE_AUTOMATIC_SMS
     * @uses self::VALUE_AUTOMATIC_MAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO,
            self::VALUE_PREDICT,
            self::VALUE_AUTOMATIC_SMS,
            self::VALUE_AUTOMATIC_MAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
