<?php

namespace EnumType;

/**
 * This class stands for etypeConsolidation EnumType
 * @subpackage Enumerations
 */
class EtypeConsolidation
{
    /**
     * Constant for value 'CombinedDelivery'
     * @return string 'CombinedDelivery'
     */
    const VALUE_COMBINED_DELIVERY = 'CombinedDelivery';
    /**
     * Constant for value 'CombinedInvoicing'
     * @return string 'CombinedInvoicing'
     */
    const VALUE_COMBINED_INVOICING = 'CombinedInvoicing';
    /**
     * Constant for value 'CombinedDeliveryAndInvoicing'
     * @return string 'CombinedDeliveryAndInvoicing'
     */
    const VALUE_COMBINED_DELIVERY_AND_INVOICING = 'CombinedDeliveryAndInvoicing';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMBINED_DELIVERY
     * @uses self::VALUE_COMBINED_INVOICING
     * @uses self::VALUE_COMBINED_DELIVERY_AND_INVOICING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMBINED_DELIVERY,
            self::VALUE_COMBINED_INVOICING,
            self::VALUE_COMBINED_DELIVERY_AND_INVOICING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
