<?php

namespace EnumType;

/**
 * This class stands for eBic3Mode EnumType
 * @subpackage Enumerations
 */
class EBic3Mode
{
    /**
     * Constant for value 'OnlyStdLabels'
     * @return string 'OnlyStdLabels'
     */
    const VALUE_ONLY_STD_LABELS = 'OnlyStdLabels';
    /**
     * Constant for value 'OnlyBic3'
     * @return string 'OnlyBic3'
     */
    const VALUE_ONLY_BIC_3 = 'OnlyBic3';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONLY_STD_LABELS
     * @uses self::VALUE_ONLY_BIC_3
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLY_STD_LABELS,
            self::VALUE_ONLY_BIC_3,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
