<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateServiceNoticeRequest StructType
 * @subpackage Structs
 */
class UpdateServiceNoticeRequest extends AbstractStructBase
{
    /**
     * The answerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $answerID;
    /**
     * The parcel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Parcel
     */
    public $parcel;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $address;
    /**
     * Constructor method for UpdateServiceNoticeRequest
     * @uses UpdateServiceNoticeRequest::setAnswerID()
     * @uses UpdateServiceNoticeRequest::setParcel()
     * @uses UpdateServiceNoticeRequest::setCustomer()
     * @uses UpdateServiceNoticeRequest::setText()
     * @uses UpdateServiceNoticeRequest::setAddress()
     * @param int $answerID
     * @param \StructType\Parcel $parcel
     * @param \StructType\Customer $customer
     * @param string $text
     * @param \StructType\Address $address
     */
    public function __construct($answerID = null, \StructType\Parcel $parcel = null, \StructType\Customer $customer = null, $text = null, \StructType\Address $address = null)
    {
        $this
            ->setAnswerID($answerID)
            ->setParcel($parcel)
            ->setCustomer($customer)
            ->setText($text)
            ->setAddress($address);
    }
    /**
     * Get answerID value
     * @return int
     */
    public function getAnswerID()
    {
        return $this->answerID;
    }
    /**
     * Set answerID value
     * @param int $answerID
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public function setAnswerID($answerID = null)
    {
        // validation for constraint: int
        if (!is_null($answerID) && !(is_int($answerID) || ctype_digit($answerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($answerID, true), gettype($answerID)), __LINE__);
        }
        $this->answerID = $answerID;
        return $this;
    }
    /**
     * Get parcel value
     * @return \StructType\Parcel|null
     */
    public function getParcel()
    {
        return $this->parcel;
    }
    /**
     * Set parcel value
     * @param \StructType\Parcel $parcel
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public function setParcel(\StructType\Parcel $parcel = null)
    {
        $this->parcel = $parcel;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\Address $address
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateServiceNoticeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
