<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRdvShipmentData StructType
 * @subpackage Structs
 */
class UpdateRdvShipmentData extends AbstractStructBase
{
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParcelNumber;
    /**
     * Constructor method for UpdateRdvShipmentData
     * @uses UpdateRdvShipmentData::setParcelNumber()
     * @param string $parcelNumber
     */
    public function __construct($parcelNumber = null)
    {
        $this
            ->setParcelNumber($parcelNumber);
    }
    /**
     * Get ParcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param string $parcelNumber
     * @return \StructType\UpdateRdvShipmentData
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRdvShipmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
