<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDataExtended StructType
 * @subpackage Structs
 */
class ShipmentDataExtended extends AbstractStructBase
{
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countrycode;
    /**
     * The centernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $centernumber;
    /**
     * The parcelnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelnumber;
    /**
     * The customer_centernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer_centernumber;
    /**
     * The customernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customernumber;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The shipping_date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipping_date;
    /**
     * The referencenumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $referencenumber;
    /**
     * The reference2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference2;
    /**
     * The reference3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference3;
    /**
     * The reference4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reference4;
    /**
     * The shipperaddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shipperaddress;
    /**
     * The customeraddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $customeraddress;
    /**
     * The receiveraddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $receiveraddress;
    /**
     * The receiver_contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Contact
     */
    public $receiver_contact;
    /**
     * The pickup_remark
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickup_remark;
    /**
     * The deliver_remark
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deliver_remark;
    /**
     * The receiverinfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressInfo
     */
    public $receiverinfo;
    /**
     * Constructor method for ShipmentDataExtended
     * @uses ShipmentDataExtended::setCountrycode()
     * @uses ShipmentDataExtended::setCenternumber()
     * @uses ShipmentDataExtended::setParcelnumber()
     * @uses ShipmentDataExtended::setCustomer_centernumber()
     * @uses ShipmentDataExtended::setCustomernumber()
     * @uses ShipmentDataExtended::setWeight()
     * @uses ShipmentDataExtended::setShipping_date()
     * @uses ShipmentDataExtended::setReferencenumber()
     * @uses ShipmentDataExtended::setReference2()
     * @uses ShipmentDataExtended::setReference3()
     * @uses ShipmentDataExtended::setReference4()
     * @uses ShipmentDataExtended::setShipperaddress()
     * @uses ShipmentDataExtended::setCustomeraddress()
     * @uses ShipmentDataExtended::setReceiveraddress()
     * @uses ShipmentDataExtended::setReceiver_contact()
     * @uses ShipmentDataExtended::setPickup_remark()
     * @uses ShipmentDataExtended::setDeliver_remark()
     * @uses ShipmentDataExtended::setReceiverinfo()
     * @param string $countrycode
     * @param string $centernumber
     * @param string $parcelnumber
     * @param string $customer_centernumber
     * @param string $customernumber
     * @param string $weight
     * @param string $shipping_date
     * @param string $referencenumber
     * @param string $reference2
     * @param string $reference3
     * @param string $reference4
     * @param \StructType\Address $shipperaddress
     * @param \StructType\Address $customeraddress
     * @param \StructType\Address $receiveraddress
     * @param \StructType\Contact $receiver_contact
     * @param string $pickup_remark
     * @param string $deliver_remark
     * @param \StructType\AddressInfo $receiverinfo
     */
    public function __construct($countrycode = null, $centernumber = null, $parcelnumber = null, $customer_centernumber = null, $customernumber = null, $weight = null, $shipping_date = null, $referencenumber = null, $reference2 = null, $reference3 = null, $reference4 = null, \StructType\Address $shipperaddress = null, \StructType\Address $customeraddress = null, \StructType\Address $receiveraddress = null, \StructType\Contact $receiver_contact = null, $pickup_remark = null, $deliver_remark = null, \StructType\AddressInfo $receiverinfo = null)
    {
        $this
            ->setCountrycode($countrycode)
            ->setCenternumber($centernumber)
            ->setParcelnumber($parcelnumber)
            ->setCustomer_centernumber($customer_centernumber)
            ->setCustomernumber($customernumber)
            ->setWeight($weight)
            ->setShipping_date($shipping_date)
            ->setReferencenumber($referencenumber)
            ->setReference2($reference2)
            ->setReference3($reference3)
            ->setReference4($reference4)
            ->setShipperaddress($shipperaddress)
            ->setCustomeraddress($customeraddress)
            ->setReceiveraddress($receiveraddress)
            ->setReceiver_contact($receiver_contact)
            ->setPickup_remark($pickup_remark)
            ->setDeliver_remark($deliver_remark)
            ->setReceiverinfo($receiverinfo);
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \StructType\ShipmentDataExtended
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get centernumber value
     * @return string|null
     */
    public function getCenternumber()
    {
        return $this->centernumber;
    }
    /**
     * Set centernumber value
     * @param string $centernumber
     * @return \StructType\ShipmentDataExtended
     */
    public function setCenternumber($centernumber = null)
    {
        // validation for constraint: string
        if (!is_null($centernumber) && !is_string($centernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centernumber, true), gettype($centernumber)), __LINE__);
        }
        $this->centernumber = $centernumber;
        return $this;
    }
    /**
     * Get parcelnumber value
     * @return string|null
     */
    public function getParcelnumber()
    {
        return $this->parcelnumber;
    }
    /**
     * Set parcelnumber value
     * @param string $parcelnumber
     * @return \StructType\ShipmentDataExtended
     */
    public function setParcelnumber($parcelnumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelnumber) && !is_string($parcelnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelnumber, true), gettype($parcelnumber)), __LINE__);
        }
        $this->parcelnumber = $parcelnumber;
        return $this;
    }
    /**
     * Get customer_centernumber value
     * @return string|null
     */
    public function getCustomer_centernumber()
    {
        return $this->customer_centernumber;
    }
    /**
     * Set customer_centernumber value
     * @param string $customer_centernumber
     * @return \StructType\ShipmentDataExtended
     */
    public function setCustomer_centernumber($customer_centernumber = null)
    {
        // validation for constraint: string
        if (!is_null($customer_centernumber) && !is_string($customer_centernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_centernumber, true), gettype($customer_centernumber)), __LINE__);
        }
        $this->customer_centernumber = $customer_centernumber;
        return $this;
    }
    /**
     * Get customernumber value
     * @return string|null
     */
    public function getCustomernumber()
    {
        return $this->customernumber;
    }
    /**
     * Set customernumber value
     * @param string $customernumber
     * @return \StructType\ShipmentDataExtended
     */
    public function setCustomernumber($customernumber = null)
    {
        // validation for constraint: string
        if (!is_null($customernumber) && !is_string($customernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customernumber, true), gettype($customernumber)), __LINE__);
        }
        $this->customernumber = $customernumber;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param string $weight
     * @return \StructType\ShipmentDataExtended
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get shipping_date value
     * @return string|null
     */
    public function getShipping_date()
    {
        return $this->shipping_date;
    }
    /**
     * Set shipping_date value
     * @param string $shipping_date
     * @return \StructType\ShipmentDataExtended
     */
    public function setShipping_date($shipping_date = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_date) && !is_string($shipping_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_date, true), gettype($shipping_date)), __LINE__);
        }
        $this->shipping_date = $shipping_date;
        return $this;
    }
    /**
     * Get referencenumber value
     * @return string|null
     */
    public function getReferencenumber()
    {
        return $this->referencenumber;
    }
    /**
     * Set referencenumber value
     * @param string $referencenumber
     * @return \StructType\ShipmentDataExtended
     */
    public function setReferencenumber($referencenumber = null)
    {
        // validation for constraint: string
        if (!is_null($referencenumber) && !is_string($referencenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencenumber, true), gettype($referencenumber)), __LINE__);
        }
        $this->referencenumber = $referencenumber;
        return $this;
    }
    /**
     * Get reference2 value
     * @return string|null
     */
    public function getReference2()
    {
        return $this->reference2;
    }
    /**
     * Set reference2 value
     * @param string $reference2
     * @return \StructType\ShipmentDataExtended
     */
    public function setReference2($reference2 = null)
    {
        // validation for constraint: string
        if (!is_null($reference2) && !is_string($reference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference2, true), gettype($reference2)), __LINE__);
        }
        $this->reference2 = $reference2;
        return $this;
    }
    /**
     * Get reference3 value
     * @return string|null
     */
    public function getReference3()
    {
        return $this->reference3;
    }
    /**
     * Set reference3 value
     * @param string $reference3
     * @return \StructType\ShipmentDataExtended
     */
    public function setReference3($reference3 = null)
    {
        // validation for constraint: string
        if (!is_null($reference3) && !is_string($reference3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference3, true), gettype($reference3)), __LINE__);
        }
        $this->reference3 = $reference3;
        return $this;
    }
    /**
     * Get reference4 value
     * @return string|null
     */
    public function getReference4()
    {
        return $this->reference4;
    }
    /**
     * Set reference4 value
     * @param string $reference4
     * @return \StructType\ShipmentDataExtended
     */
    public function setReference4($reference4 = null)
    {
        // validation for constraint: string
        if (!is_null($reference4) && !is_string($reference4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference4, true), gettype($reference4)), __LINE__);
        }
        $this->reference4 = $reference4;
        return $this;
    }
    /**
     * Get shipperaddress value
     * @return \StructType\Address|null
     */
    public function getShipperaddress()
    {
        return $this->shipperaddress;
    }
    /**
     * Set shipperaddress value
     * @param \StructType\Address $shipperaddress
     * @return \StructType\ShipmentDataExtended
     */
    public function setShipperaddress(\StructType\Address $shipperaddress = null)
    {
        $this->shipperaddress = $shipperaddress;
        return $this;
    }
    /**
     * Get customeraddress value
     * @return \StructType\Address|null
     */
    public function getCustomeraddress()
    {
        return $this->customeraddress;
    }
    /**
     * Set customeraddress value
     * @param \StructType\Address $customeraddress
     * @return \StructType\ShipmentDataExtended
     */
    public function setCustomeraddress(\StructType\Address $customeraddress = null)
    {
        $this->customeraddress = $customeraddress;
        return $this;
    }
    /**
     * Get receiveraddress value
     * @return \StructType\Address|null
     */
    public function getReceiveraddress()
    {
        return $this->receiveraddress;
    }
    /**
     * Set receiveraddress value
     * @param \StructType\Address $receiveraddress
     * @return \StructType\ShipmentDataExtended
     */
    public function setReceiveraddress(\StructType\Address $receiveraddress = null)
    {
        $this->receiveraddress = $receiveraddress;
        return $this;
    }
    /**
     * Get receiver_contact value
     * @return \StructType\Contact|null
     */
    public function getReceiver_contact()
    {
        return $this->receiver_contact;
    }
    /**
     * Set receiver_contact value
     * @param \StructType\Contact $receiver_contact
     * @return \StructType\ShipmentDataExtended
     */
    public function setReceiver_contact(\StructType\Contact $receiver_contact = null)
    {
        $this->receiver_contact = $receiver_contact;
        return $this;
    }
    /**
     * Get pickup_remark value
     * @return string|null
     */
    public function getPickup_remark()
    {
        return $this->pickup_remark;
    }
    /**
     * Set pickup_remark value
     * @param string $pickup_remark
     * @return \StructType\ShipmentDataExtended
     */
    public function setPickup_remark($pickup_remark = null)
    {
        // validation for constraint: string
        if (!is_null($pickup_remark) && !is_string($pickup_remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickup_remark, true), gettype($pickup_remark)), __LINE__);
        }
        $this->pickup_remark = $pickup_remark;
        return $this;
    }
    /**
     * Get deliver_remark value
     * @return string|null
     */
    public function getDeliver_remark()
    {
        return $this->deliver_remark;
    }
    /**
     * Set deliver_remark value
     * @param string $deliver_remark
     * @return \StructType\ShipmentDataExtended
     */
    public function setDeliver_remark($deliver_remark = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_remark) && !is_string($deliver_remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_remark, true), gettype($deliver_remark)), __LINE__);
        }
        $this->deliver_remark = $deliver_remark;
        return $this;
    }
    /**
     * Get receiverinfo value
     * @return \StructType\AddressInfo|null
     */
    public function getReceiverinfo()
    {
        return $this->receiverinfo;
    }
    /**
     * Set receiverinfo value
     * @param \StructType\AddressInfo $receiverinfo
     * @return \StructType\ShipmentDataExtended
     */
    public function setReceiverinfo(\StructType\AddressInfo $receiverinfo = null)
    {
        $this->receiverinfo = $receiverinfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentDataExtended
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
