<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentData StructType
 * @subpackage Structs
 */
class ShipmentData extends AbstractStructBase
{
    /**
     * The countrycode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countrycode;
    /**
     * The centernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $centernumber;
    /**
     * The parcelnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelnumber;
    /**
     * The countrycode_retour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $countrycode_retour;
    /**
     * The centernumber_retour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $centernumber_retour;
    /**
     * The parcelnumber_retour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parcelnumber_retour;
    /**
     * The customer_centernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer_centernumber;
    /**
     * The customernumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customernumber;
    /**
     * The shipperaddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shipperaddress;
    /**
     * The customeraddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $customeraddress;
    /**
     * The receiveraddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $receiveraddress;
    /**
     * Constructor method for ShipmentData
     * @uses ShipmentData::setCountrycode()
     * @uses ShipmentData::setCenternumber()
     * @uses ShipmentData::setParcelnumber()
     * @uses ShipmentData::setCountrycode_retour()
     * @uses ShipmentData::setCenternumber_retour()
     * @uses ShipmentData::setParcelnumber_retour()
     * @uses ShipmentData::setCustomer_centernumber()
     * @uses ShipmentData::setCustomernumber()
     * @uses ShipmentData::setShipperaddress()
     * @uses ShipmentData::setCustomeraddress()
     * @uses ShipmentData::setReceiveraddress()
     * @param string $countrycode
     * @param string $centernumber
     * @param string $parcelnumber
     * @param string $countrycode_retour
     * @param string $centernumber_retour
     * @param string $parcelnumber_retour
     * @param string $customer_centernumber
     * @param string $customernumber
     * @param \StructType\Address $shipperaddress
     * @param \StructType\Address $customeraddress
     * @param \StructType\Address $receiveraddress
     */
    public function __construct($countrycode = null, $centernumber = null, $parcelnumber = null, $countrycode_retour = null, $centernumber_retour = null, $parcelnumber_retour = null, $customer_centernumber = null, $customernumber = null, \StructType\Address $shipperaddress = null, \StructType\Address $customeraddress = null, \StructType\Address $receiveraddress = null)
    {
        $this
            ->setCountrycode($countrycode)
            ->setCenternumber($centernumber)
            ->setParcelnumber($parcelnumber)
            ->setCountrycode_retour($countrycode_retour)
            ->setCenternumber_retour($centernumber_retour)
            ->setParcelnumber_retour($parcelnumber_retour)
            ->setCustomer_centernumber($customer_centernumber)
            ->setCustomernumber($customernumber)
            ->setShipperaddress($shipperaddress)
            ->setCustomeraddress($customeraddress)
            ->setReceiveraddress($receiveraddress);
    }
    /**
     * Get countrycode value
     * @return string|null
     */
    public function getCountrycode()
    {
        return $this->countrycode;
    }
    /**
     * Set countrycode value
     * @param string $countrycode
     * @return \StructType\ShipmentData
     */
    public function setCountrycode($countrycode = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode) && !is_string($countrycode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode, true), gettype($countrycode)), __LINE__);
        }
        $this->countrycode = $countrycode;
        return $this;
    }
    /**
     * Get centernumber value
     * @return string|null
     */
    public function getCenternumber()
    {
        return $this->centernumber;
    }
    /**
     * Set centernumber value
     * @param string $centernumber
     * @return \StructType\ShipmentData
     */
    public function setCenternumber($centernumber = null)
    {
        // validation for constraint: string
        if (!is_null($centernumber) && !is_string($centernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centernumber, true), gettype($centernumber)), __LINE__);
        }
        $this->centernumber = $centernumber;
        return $this;
    }
    /**
     * Get parcelnumber value
     * @return string|null
     */
    public function getParcelnumber()
    {
        return $this->parcelnumber;
    }
    /**
     * Set parcelnumber value
     * @param string $parcelnumber
     * @return \StructType\ShipmentData
     */
    public function setParcelnumber($parcelnumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelnumber) && !is_string($parcelnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelnumber, true), gettype($parcelnumber)), __LINE__);
        }
        $this->parcelnumber = $parcelnumber;
        return $this;
    }
    /**
     * Get countrycode_retour value
     * @return string|null
     */
    public function getCountrycode_retour()
    {
        return $this->countrycode_retour;
    }
    /**
     * Set countrycode_retour value
     * @param string $countrycode_retour
     * @return \StructType\ShipmentData
     */
    public function setCountrycode_retour($countrycode_retour = null)
    {
        // validation for constraint: string
        if (!is_null($countrycode_retour) && !is_string($countrycode_retour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countrycode_retour, true), gettype($countrycode_retour)), __LINE__);
        }
        $this->countrycode_retour = $countrycode_retour;
        return $this;
    }
    /**
     * Get centernumber_retour value
     * @return string|null
     */
    public function getCenternumber_retour()
    {
        return $this->centernumber_retour;
    }
    /**
     * Set centernumber_retour value
     * @param string $centernumber_retour
     * @return \StructType\ShipmentData
     */
    public function setCenternumber_retour($centernumber_retour = null)
    {
        // validation for constraint: string
        if (!is_null($centernumber_retour) && !is_string($centernumber_retour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centernumber_retour, true), gettype($centernumber_retour)), __LINE__);
        }
        $this->centernumber_retour = $centernumber_retour;
        return $this;
    }
    /**
     * Get parcelnumber_retour value
     * @return string|null
     */
    public function getParcelnumber_retour()
    {
        return $this->parcelnumber_retour;
    }
    /**
     * Set parcelnumber_retour value
     * @param string $parcelnumber_retour
     * @return \StructType\ShipmentData
     */
    public function setParcelnumber_retour($parcelnumber_retour = null)
    {
        // validation for constraint: string
        if (!is_null($parcelnumber_retour) && !is_string($parcelnumber_retour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelnumber_retour, true), gettype($parcelnumber_retour)), __LINE__);
        }
        $this->parcelnumber_retour = $parcelnumber_retour;
        return $this;
    }
    /**
     * Get customer_centernumber value
     * @return string|null
     */
    public function getCustomer_centernumber()
    {
        return $this->customer_centernumber;
    }
    /**
     * Set customer_centernumber value
     * @param string $customer_centernumber
     * @return \StructType\ShipmentData
     */
    public function setCustomer_centernumber($customer_centernumber = null)
    {
        // validation for constraint: string
        if (!is_null($customer_centernumber) && !is_string($customer_centernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_centernumber, true), gettype($customer_centernumber)), __LINE__);
        }
        $this->customer_centernumber = $customer_centernumber;
        return $this;
    }
    /**
     * Get customernumber value
     * @return string|null
     */
    public function getCustomernumber()
    {
        return $this->customernumber;
    }
    /**
     * Set customernumber value
     * @param string $customernumber
     * @return \StructType\ShipmentData
     */
    public function setCustomernumber($customernumber = null)
    {
        // validation for constraint: string
        if (!is_null($customernumber) && !is_string($customernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customernumber, true), gettype($customernumber)), __LINE__);
        }
        $this->customernumber = $customernumber;
        return $this;
    }
    /**
     * Get shipperaddress value
     * @return \StructType\Address|null
     */
    public function getShipperaddress()
    {
        return $this->shipperaddress;
    }
    /**
     * Set shipperaddress value
     * @param \StructType\Address $shipperaddress
     * @return \StructType\ShipmentData
     */
    public function setShipperaddress(\StructType\Address $shipperaddress = null)
    {
        $this->shipperaddress = $shipperaddress;
        return $this;
    }
    /**
     * Get customeraddress value
     * @return \StructType\Address|null
     */
    public function getCustomeraddress()
    {
        return $this->customeraddress;
    }
    /**
     * Set customeraddress value
     * @param \StructType\Address $customeraddress
     * @return \StructType\ShipmentData
     */
    public function setCustomeraddress(\StructType\Address $customeraddress = null)
    {
        $this->customeraddress = $customeraddress;
        return $this;
    }
    /**
     * Get receiveraddress value
     * @return \StructType\Address|null
     */
    public function getReceiveraddress()
    {
        return $this->receiveraddress;
    }
    /**
     * Set receiveraddress value
     * @param \StructType\Address $receiveraddress
     * @return \StructType\ShipmentData
     */
    public function setReceiveraddress(\StructType\Address $receiveraddress = null)
    {
        $this->receiveraddress = $receiveraddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
