<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyDefinition StructType
 * @subpackage Structs
 */
class PropertyDefinition extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The PropertyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyType;
    /**
     * The DataType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataType;
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Property;
    /**
     * The Query
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Query;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Options;
    /**
     * Constructor method for PropertyDefinition
     * @uses PropertyDefinition::setId()
     * @uses PropertyDefinition::setPropertyType()
     * @uses PropertyDefinition::setDataType()
     * @uses PropertyDefinition::setProperty()
     * @uses PropertyDefinition::setQuery()
     * @uses PropertyDefinition::setOptions()
     * @param int $id
     * @param string $propertyType
     * @param string $dataType
     * @param string $property
     * @param string $query
     * @param string $options
     */
    public function __construct($id = null, $propertyType = null, $dataType = null, $property = null, $query = null, $options = null)
    {
        $this
            ->setId($id)
            ->setPropertyType($propertyType)
            ->setDataType($dataType)
            ->setProperty($property)
            ->setQuery($query)
            ->setOptions($options);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\PropertyDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @param string $propertyType
     * @return \StructType\PropertyDefinition
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyType) && !is_string($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyType, true), gettype($propertyType)), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param string $dataType
     * @return \StructType\PropertyDefinition
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataType, true), gettype($dataType)), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get Property value
     * @return string|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * Set Property value
     * @param string $property
     * @return \StructType\PropertyDefinition
     */
    public function setProperty($property = null)
    {
        // validation for constraint: string
        if (!is_null($property) && !is_string($property)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($property, true), gettype($property)), __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
    /**
     * Get Query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param string $query
     * @return \StructType\PropertyDefinition
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($query, true), gettype($query)), __LINE__);
        }
        $this->Query = $query;
        return $this;
    }
    /**
     * Get Options value
     * @return string|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param string $options
     * @return \StructType\PropertyDefinition
     */
    public function setOptions($options = null)
    {
        // validation for constraint: string
        if (!is_null($options) && !is_string($options)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($options, true), gettype($options)), __LINE__);
        }
        $this->Options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PropertyDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
