<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRdvShipmentDataRequest StructType
 * @subpackage Structs
 */
class GetRdvShipmentDataRequest extends AbstractStructBase
{
    /**
     * The SearchMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SearchMode;
    /**
     * The SearchString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchString;
    /**
     * Constructor method for GetRdvShipmentDataRequest
     * @uses GetRdvShipmentDataRequest::setSearchMode()
     * @uses GetRdvShipmentDataRequest::setSearchString()
     * @param string $searchMode
     * @param string $searchString
     */
    public function __construct($searchMode = null, $searchString = null)
    {
        $this
            ->setSearchMode($searchMode)
            ->setSearchString($searchString);
    }
    /**
     * Get SearchMode value
     * @return string
     */
    public function getSearchMode()
    {
        return $this->SearchMode;
    }
    /**
     * Set SearchMode value
     * @uses \EnumType\RdvShipmentDataSearchMode::valueIsValid()
     * @uses \EnumType\RdvShipmentDataSearchMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchMode
     * @return \StructType\GetRdvShipmentDataRequest
     */
    public function setSearchMode($searchMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RdvShipmentDataSearchMode::valueIsValid($searchMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RdvShipmentDataSearchMode', is_array($searchMode) ? implode(', ', $searchMode) : var_export($searchMode, true), implode(', ', \EnumType\RdvShipmentDataSearchMode::getValidValues())), __LINE__);
        }
        $this->SearchMode = $searchMode;
        return $this;
    }
    /**
     * Get SearchString value
     * @return string|null
     */
    public function getSearchString()
    {
        return $this->SearchString;
    }
    /**
     * Set SearchString value
     * @param string $searchString
     * @return \StructType\GetRdvShipmentDataRequest
     */
    public function setSearchString($searchString = null)
    {
        // validation for constraint: string
        if (!is_null($searchString) && !is_string($searchString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchString, true), gettype($searchString)), __LINE__);
        }
        $this->SearchString = $searchString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRdvShipmentDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
