<?php

namespace EnumType;

/**
 * This class stands for etypeReverse EnumType
 * @subpackage Enumerations
 */
class EtypeReverse
{
    /**
     * Constant for value 'OnDemand'
     * @return string 'OnDemand'
     */
    const VALUE_ON_DEMAND = 'OnDemand';
    /**
     * Constant for value 'Prepared'
     * @return string 'Prepared'
     */
    const VALUE_PREPARED = 'Prepared';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_DEMAND
     * @uses self::VALUE_PREPARED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_DEMAND,
            self::VALUE_PREPARED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
