<?php

namespace EnumType;

/**
 * This class stands for etype EnumType
 * @subpackage Enumerations
 */
class Etype
{
    /**
     * Constant for value 'REVERSE'
     * @return string 'REVERSE'
     */
    const VALUE_REVERSE = 'REVERSE';
    /**
     * Constant for value 'PROOF'
     * @return string 'PROOF'
     */
    const VALUE_PROOF = 'PROOF';
    /**
     * Constant for value 'EPRINT'
     * @return string 'EPRINT'
     */
    const VALUE_EPRINT = 'EPRINT';
    /**
     * Constant for value 'EPRINTATTACHMENT'
     * @return string 'EPRINTATTACHMENT'
     */
    const VALUE_EPRINTATTACHMENT = 'EPRINTATTACHMENT';
    /**
     * Constant for value 'MASTER'
     * @return string 'MASTER'
     */
    const VALUE_MASTER = 'MASTER';
    /**
     * Constant for value 'COLLECTIONREQUEST'
     * @return string 'COLLECTIONREQUEST'
     */
    const VALUE_COLLECTIONREQUEST = 'COLLECTIONREQUEST';
    /**
     * Constant for value 'BIC3'
     * @return string 'BIC3'
     */
    const VALUE_BIC_3 = 'BIC3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REVERSE
     * @uses self::VALUE_PROOF
     * @uses self::VALUE_EPRINT
     * @uses self::VALUE_EPRINTATTACHMENT
     * @uses self::VALUE_MASTER
     * @uses self::VALUE_COLLECTIONREQUEST
     * @uses self::VALUE_BIC_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REVERSE,
            self::VALUE_PROOF,
            self::VALUE_EPRINT,
            self::VALUE_EPRINTATTACHMENT,
            self::VALUE_MASTER,
            self::VALUE_COLLECTIONREQUEST,
            self::VALUE_BIC_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
