<?php

namespace EnumType;

/**
 * This class stands for CheckReverseInverseShipmentReturn EnumType
 * @subpackage Enumerations
 */
class CheckReverseInverseShipmentReturn
{
    /**
     * Constant for value 'WellDone'
     * @return string 'WellDone'
     */
    const VALUE_WELL_DONE = 'WellDone';
    /**
     * Constant for value 'OriginalShipmentNotFound'
     * @return string 'OriginalShipmentNotFound'
     */
    const VALUE_ORIGINAL_SHIPMENT_NOT_FOUND = 'OriginalShipmentNotFound';
    /**
     * Constant for value 'OriginalShipmentAlreadyLinked'
     * @return string 'OriginalShipmentAlreadyLinked'
     */
    const VALUE_ORIGINAL_SHIPMENT_ALREADY_LINKED = 'OriginalShipmentAlreadyLinked';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WELL_DONE
     * @uses self::VALUE_ORIGINAL_SHIPMENT_NOT_FOUND
     * @uses self::VALUE_ORIGINAL_SHIPMENT_ALREADY_LINKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WELL_DONE,
            self::VALUE_ORIGINAL_SHIPMENT_NOT_FOUND,
            self::VALUE_ORIGINAL_SHIPMENT_ALREADY_LINKED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
