<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://sandbox.contrat-prive.com/webService/api.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://sandbox.contrat-prive.com/webService/api.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkConnexion operation/method
 */
if ($check->checkConnexion(new \StructType\CheckConnexionRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Contract ServiceType
 */
$contract = new \ServiceType\Contract($options);
/**
 * Sample call for contractDelete operation/method
 */
if ($contract->contractDelete(new \StructType\ContractDeleteRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Sample call for contractCancel operation/method
 */
if ($contract->contractCancel(new \StructType\ContractCancelRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Sample call for contractCreate operation/method
 */
if ($contract->contractCreate(new \StructType\ContractCreateRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Sample call for contractDetail operation/method
 */
if ($contract->contractDetail(new \StructType\ContractDetailRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Sample call for contractFinalize operation/method
 */
if ($contract->contractFinalize(new \StructType\ContractFinalizeRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Sample call for contractList operation/method
 */
if ($contract->contractList(new \StructType\ContractListRequest()) !== false) {
    print_r($contract->getResult());
} else {
    print_r($contract->getLastError());
}
/**
 * Samples for Signatory ServiceType
 */
$signatory = new \ServiceType\Signatory($options);
/**
 * Sample call for signatorySendSms operation/method
 */
if ($signatory->signatorySendSms(new \StructType\SignatorySendSmsRequest()) !== false) {
    print_r($signatory->getResult());
} else {
    print_r($signatory->getLastError());
}
/**
 * Sample call for signatorySendAllSms operation/method
 */
if ($signatory->signatorySendAllSms(new \StructType\SignatorySendAllSmsRequest()) !== false) {
    print_r($signatory->getResult());
} else {
    print_r($signatory->getLastError());
}
/**
 * Sample call for signatorySendOneSms operation/method
 */
if ($signatory->signatorySendOneSms(new \StructType\SignatorySendOneSmsRequest()) !== false) {
    print_r($signatory->getResult());
} else {
    print_r($signatory->getLastError());
}
/**
 * Sample call for signatorySign operation/method
 */
if ($signatory->signatorySign(new \StructType\SignatorySignRequest()) !== false) {
    print_r($signatory->getResult());
} else {
    print_r($signatory->getLastError());
}
