<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatorySignResponse StructType
 * @subpackage Structs
 */
class SignatorySignResponse extends AbstractStructBase
{
    /**
     * The success
     * @var bool
     */
    public $success;
    /**
     * The paymentRequired
     * @var bool
     */
    public $paymentRequired;
    /**
     * Constructor method for signatorySignResponse
     * @uses SignatorySignResponse::setSuccess()
     * @uses SignatorySignResponse::setPaymentRequired()
     * @param bool $success
     * @param bool $paymentRequired
     */
    public function __construct($success = null, $paymentRequired = null)
    {
        $this
            ->setSuccess($success)
            ->setPaymentRequired($paymentRequired);
    }
    /**
     * Get success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param bool $success
     * @return \StructType\SignatorySignResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Get paymentRequired value
     * @return bool|null
     */
    public function getPaymentRequired()
    {
        return $this->paymentRequired;
    }
    /**
     * Set paymentRequired value
     * @param bool $paymentRequired
     * @return \StructType\SignatorySignResponse
     */
    public function setPaymentRequired($paymentRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentRequired) && !is_bool($paymentRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentRequired, true), gettype($paymentRequired)), __LINE__);
        }
        $this->paymentRequired = $paymentRequired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignatorySignResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
