<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatorySignRequest StructType
 * @subpackage Structs
 */
class SignatorySignRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \StructType\RequestToken
     */
    public $requestToken;
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The signatoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $signatoryId;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $code;
    /**
     * Constructor method for signatorySignRequest
     * @uses SignatorySignRequest::setRequestToken()
     * @uses SignatorySignRequest::setPublicId()
     * @uses SignatorySignRequest::setSignatoryId()
     * @uses SignatorySignRequest::setCode()
     * @param \StructType\RequestToken $requestToken
     * @param string $publicId
     * @param string $signatoryId
     * @param string $code
     */
    public function __construct(\StructType\RequestToken $requestToken = null, $publicId = null, $signatoryId = null, $code = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setPublicId($publicId)
            ->setSignatoryId($signatoryId)
            ->setCode($code);
    }
    /**
     * Get requestToken value
     * @return \StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \StructType\RequestToken $requestToken
     * @return \StructType\SignatorySignRequest
     */
    public function setRequestToken(\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \StructType\SignatorySignRequest
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get signatoryId value
     * @return string|null
     */
    public function getSignatoryId()
    {
        return $this->signatoryId;
    }
    /**
     * Set signatoryId value
     * @param string $signatoryId
     * @return \StructType\SignatorySignRequest
     */
    public function setSignatoryId($signatoryId = null)
    {
        // validation for constraint: string
        if (!is_null($signatoryId) && !is_string($signatoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatoryId, true), gettype($signatoryId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($signatoryId) && mb_strlen($signatoryId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($signatoryId)), __LINE__);
        }
        $this->signatoryId = $signatoryId;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SignatorySignRequest
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($code) && mb_strlen($code) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignatorySignRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
