<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatorySendSmsRequest StructType
 * @subpackage Structs
 */
class SignatorySendSmsRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \StructType\RequestToken
     */
    public $requestToken;
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The signatoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $signatoryId;
    /**
     * Constructor method for signatorySendSmsRequest
     * @uses SignatorySendSmsRequest::setRequestToken()
     * @uses SignatorySendSmsRequest::setPublicId()
     * @uses SignatorySendSmsRequest::setSignatoryId()
     * @param \StructType\RequestToken $requestToken
     * @param string $publicId
     * @param string $signatoryId
     */
    public function __construct(\StructType\RequestToken $requestToken = null, $publicId = null, $signatoryId = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setPublicId($publicId)
            ->setSignatoryId($signatoryId);
    }
    /**
     * Get requestToken value
     * @return \StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \StructType\RequestToken $requestToken
     * @return \StructType\SignatorySendSmsRequest
     */
    public function setRequestToken(\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \StructType\SignatorySendSmsRequest
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get signatoryId value
     * @return string|null
     */
    public function getSignatoryId()
    {
        return $this->signatoryId;
    }
    /**
     * Set signatoryId value
     * @param string $signatoryId
     * @return \StructType\SignatorySendSmsRequest
     */
    public function setSignatoryId($signatoryId = null)
    {
        // validation for constraint: string
        if (!is_null($signatoryId) && !is_string($signatoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatoryId, true), gettype($signatoryId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($signatoryId) && mb_strlen($signatoryId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($signatoryId)), __LINE__);
        }
        $this->signatoryId = $signatoryId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignatorySendSmsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
