<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notify StructType
 * @subpackage Structs
 */
class Notify extends AbstractStructBase
{
    /**
     * The signatory
     * @var bool
     */
    public $signatory;
    /**
     * The owner
     * @var bool
     */
    public $owner;
    /**
     * The submitMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submitMessage;
    /**
     * Constructor method for notify
     * @uses Notify::setSignatory()
     * @uses Notify::setOwner()
     * @uses Notify::setSubmitMessage()
     * @param bool $signatory
     * @param bool $owner
     * @param string $submitMessage
     */
    public function __construct($signatory = null, $owner = null, $submitMessage = null)
    {
        $this
            ->setSignatory($signatory)
            ->setOwner($owner)
            ->setSubmitMessage($submitMessage);
    }
    /**
     * Get signatory value
     * @return bool|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param bool $signatory
     * @return \StructType\Notify
     */
    public function setSignatory($signatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatory) && !is_bool($signatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatory, true), gettype($signatory)), __LINE__);
        }
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Get owner value
     * @return bool|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param bool $owner
     * @return \StructType\Notify
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: boolean
        if (!is_null($owner) && !is_bool($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get submitMessage value
     * @return string|null
     */
    public function getSubmitMessage()
    {
        return $this->submitMessage;
    }
    /**
     * Set submitMessage value
     * @param string $submitMessage
     * @return \StructType\Notify
     */
    public function setSubmitMessage($submitMessage = null)
    {
        // validation for constraint: string
        if (!is_null($submitMessage) && !is_string($submitMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submitMessage, true), gettype($submitMessage)), __LINE__);
        }
        $this->submitMessage = $submitMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
