<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The contentType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $contentType;
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $extension;
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $filename;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $title;
    /**
     * The numberOfPages
     * @var int
     */
    public $numberOfPages;
    /**
     * The size
     * @var int
     */
    public $size;
    /**
     * The data
     * @var string
     */
    public $data;
    /**
     * The dataSigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataSigned;
    /**
     * Constructor method for document
     * @uses Document::setPublicId()
     * @uses Document::setContentType()
     * @uses Document::setExtension()
     * @uses Document::setFilename()
     * @uses Document::setTitle()
     * @uses Document::setNumberOfPages()
     * @uses Document::setSize()
     * @uses Document::setData()
     * @uses Document::setDataSigned()
     * @param string $publicId
     * @param string $contentType
     * @param string $extension
     * @param string $filename
     * @param string $title
     * @param int $numberOfPages
     * @param int $size
     * @param string $data
     * @param string $dataSigned
     */
    public function __construct($publicId = null, $contentType = null, $extension = null, $filename = null, $title = null, $numberOfPages = null, $size = null, $data = null, $dataSigned = null)
    {
        $this
            ->setPublicId($publicId)
            ->setContentType($contentType)
            ->setExtension($extension)
            ->setFilename($filename)
            ->setTitle($title)
            ->setNumberOfPages($numberOfPages)
            ->setSize($size)
            ->setData($data)
            ->setDataSigned($dataSigned);
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \StructType\Document
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @param string $contentType
     * @return \StructType\Document
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($contentType) && mb_strlen($contentType) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($contentType)), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \StructType\Document
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($extension) && mb_strlen($extension) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\Document
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Document
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($title) && mb_strlen($title) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get numberOfPages value
     * @return int|null
     */
    public function getNumberOfPages()
    {
        return $this->numberOfPages;
    }
    /**
     * Set numberOfPages value
     * @param int $numberOfPages
     * @return \StructType\Document
     */
    public function setNumberOfPages($numberOfPages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPages) && !(is_int($numberOfPages) || ctype_digit($numberOfPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPages, true), gettype($numberOfPages)), __LINE__);
        }
        $this->numberOfPages = $numberOfPages;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\Document
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\Document
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get dataSigned value
     * @return string|null
     */
    public function getDataSigned()
    {
        return $this->dataSigned;
    }
    /**
     * Set dataSigned value
     * @param string $dataSigned
     * @return \StructType\Document
     */
    public function setDataSigned($dataSigned = null)
    {
        // validation for constraint: string
        if (!is_null($dataSigned) && !is_string($dataSigned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSigned, true), gettype($dataSigned)), __LINE__);
        }
        $this->dataSigned = $dataSigned;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
