<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractFinalizeRequest StructType
 * @subpackage Structs
 */
class ContractFinalizeRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \StructType\RequestToken
     */
    public $requestToken;
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * Constructor method for contractFinalizeRequest
     * @uses ContractFinalizeRequest::setRequestToken()
     * @uses ContractFinalizeRequest::setPublicId()
     * @param \StructType\RequestToken $requestToken
     * @param string $publicId
     */
    public function __construct(\StructType\RequestToken $requestToken = null, $publicId = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setPublicId($publicId);
    }
    /**
     * Get requestToken value
     * @return \StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \StructType\RequestToken $requestToken
     * @return \StructType\ContractFinalizeRequest
     */
    public function setRequestToken(\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \StructType\ContractFinalizeRequest
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractFinalizeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
