<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractDetailResponse StructType
 * @subpackage Structs
 */
class ContractDetailResponse extends AbstractStructBase
{
    /**
     * The contract
     * @var \StructType\Contract
     */
    public $contract;
    /**
     * The signatories
     * @var \StructType\Signatories
     */
    public $signatories;
    /**
     * The mainDocuments
     * @var \StructType\MainDocuments
     */
    public $mainDocuments;
    /**
     * The annexeDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AnnexeDocuments
     */
    public $annexeDocuments;
    /**
     * The log
     * @var string
     */
    public $log;
    /**
     * Constructor method for contractDetailResponse
     * @uses ContractDetailResponse::setContract()
     * @uses ContractDetailResponse::setSignatories()
     * @uses ContractDetailResponse::setMainDocuments()
     * @uses ContractDetailResponse::setAnnexeDocuments()
     * @uses ContractDetailResponse::setLog()
     * @param \StructType\Contract $contract
     * @param \StructType\Signatories $signatories
     * @param \StructType\MainDocuments $mainDocuments
     * @param \StructType\AnnexeDocuments $annexeDocuments
     * @param string $log
     */
    public function __construct(\StructType\Contract $contract = null, \StructType\Signatories $signatories = null, \StructType\MainDocuments $mainDocuments = null, \StructType\AnnexeDocuments $annexeDocuments = null, $log = null)
    {
        $this
            ->setContract($contract)
            ->setSignatories($signatories)
            ->setMainDocuments($mainDocuments)
            ->setAnnexeDocuments($annexeDocuments)
            ->setLog($log);
    }
    /**
     * Get contract value
     * @return \StructType\Contract|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param \StructType\Contract $contract
     * @return \StructType\ContractDetailResponse
     */
    public function setContract(\StructType\Contract $contract = null)
    {
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get signatories value
     * @return \StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \StructType\Signatories $signatories
     * @return \StructType\ContractDetailResponse
     */
    public function setSignatories(\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Get mainDocuments value
     * @return \StructType\MainDocuments|null
     */
    public function getMainDocuments()
    {
        return $this->mainDocuments;
    }
    /**
     * Set mainDocuments value
     * @param \StructType\MainDocuments $mainDocuments
     * @return \StructType\ContractDetailResponse
     */
    public function setMainDocuments(\StructType\MainDocuments $mainDocuments = null)
    {
        $this->mainDocuments = $mainDocuments;
        return $this;
    }
    /**
     * Get annexeDocuments value
     * @return \StructType\AnnexeDocuments|null
     */
    public function getAnnexeDocuments()
    {
        return $this->annexeDocuments;
    }
    /**
     * Set annexeDocuments value
     * @param \StructType\AnnexeDocuments $annexeDocuments
     * @return \StructType\ContractDetailResponse
     */
    public function setAnnexeDocuments(\StructType\AnnexeDocuments $annexeDocuments = null)
    {
        $this->annexeDocuments = $annexeDocuments;
        return $this;
    }
    /**
     * Get log value
     * @return string|null
     */
    public function getLog()
    {
        return $this->log;
    }
    /**
     * Set log value
     * @param string $log
     * @return \StructType\ContractDetailResponse
     */
    public function setLog($log = null)
    {
        // validation for constraint: string
        if (!is_null($log) && !is_string($log)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($log, true), gettype($log)), __LINE__);
        }
        $this->log = $log;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
