<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractCreateRequest StructType
 * @subpackage Structs
 */
class ContractCreateRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \StructType\RequestToken
     */
    public $requestToken;
    /**
     * The contract
     * @var \StructType\Contract
     */
    public $contract;
    /**
     * The mainDocuments
     * @var \StructType\MainDocuments
     */
    public $mainDocuments;
    /**
     * The annexeDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AnnexeDocuments
     */
    public $annexeDocuments;
    /**
     * The signatories
     * @var \StructType\Signatories
     */
    public $signatories;
    /**
     * The actions
     * @var \StructType\Actions
     */
    public $actions;
    /**
     * The notify
     * @var \StructType\Notify
     */
    public $notify;
    /**
     * Constructor method for contractCreateRequest
     * @uses ContractCreateRequest::setRequestToken()
     * @uses ContractCreateRequest::setContract()
     * @uses ContractCreateRequest::setMainDocuments()
     * @uses ContractCreateRequest::setAnnexeDocuments()
     * @uses ContractCreateRequest::setSignatories()
     * @uses ContractCreateRequest::setActions()
     * @uses ContractCreateRequest::setNotify()
     * @param \StructType\RequestToken $requestToken
     * @param \StructType\Contract $contract
     * @param \StructType\MainDocuments $mainDocuments
     * @param \StructType\AnnexeDocuments $annexeDocuments
     * @param \StructType\Signatories $signatories
     * @param \StructType\Actions $actions
     * @param \StructType\Notify $notify
     */
    public function __construct(\StructType\RequestToken $requestToken = null, \StructType\Contract $contract = null, \StructType\MainDocuments $mainDocuments = null, \StructType\AnnexeDocuments $annexeDocuments = null, \StructType\Signatories $signatories = null, \StructType\Actions $actions = null, \StructType\Notify $notify = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setContract($contract)
            ->setMainDocuments($mainDocuments)
            ->setAnnexeDocuments($annexeDocuments)
            ->setSignatories($signatories)
            ->setActions($actions)
            ->setNotify($notify);
    }
    /**
     * Get requestToken value
     * @return \StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \StructType\RequestToken $requestToken
     * @return \StructType\ContractCreateRequest
     */
    public function setRequestToken(\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get contract value
     * @return \StructType\Contract|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param \StructType\Contract $contract
     * @return \StructType\ContractCreateRequest
     */
    public function setContract(\StructType\Contract $contract = null)
    {
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get mainDocuments value
     * @return \StructType\MainDocuments|null
     */
    public function getMainDocuments()
    {
        return $this->mainDocuments;
    }
    /**
     * Set mainDocuments value
     * @param \StructType\MainDocuments $mainDocuments
     * @return \StructType\ContractCreateRequest
     */
    public function setMainDocuments(\StructType\MainDocuments $mainDocuments = null)
    {
        $this->mainDocuments = $mainDocuments;
        return $this;
    }
    /**
     * Get annexeDocuments value
     * @return \StructType\AnnexeDocuments|null
     */
    public function getAnnexeDocuments()
    {
        return $this->annexeDocuments;
    }
    /**
     * Set annexeDocuments value
     * @param \StructType\AnnexeDocuments $annexeDocuments
     * @return \StructType\ContractCreateRequest
     */
    public function setAnnexeDocuments(\StructType\AnnexeDocuments $annexeDocuments = null)
    {
        $this->annexeDocuments = $annexeDocuments;
        return $this;
    }
    /**
     * Get signatories value
     * @return \StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \StructType\Signatories $signatories
     * @return \StructType\ContractCreateRequest
     */
    public function setSignatories(\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Get actions value
     * @return \StructType\Actions|null
     */
    public function getActions()
    {
        return $this->actions;
    }
    /**
     * Set actions value
     * @param \StructType\Actions $actions
     * @return \StructType\ContractCreateRequest
     */
    public function setActions(\StructType\Actions $actions = null)
    {
        $this->actions = $actions;
        return $this;
    }
    /**
     * Get notify value
     * @return \StructType\Notify|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param \StructType\Notify $notify
     * @return \StructType\ContractCreateRequest
     */
    public function setNotify(\StructType\Notify $notify = null)
    {
        $this->notify = $notify;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractCreateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
