<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contract StructType
 * @subpackage Structs
 */
class Contract extends AbstractStructBase
{
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $title;
    /**
     * The closingDate
     * @var string
     */
    public $closingDate;
    /**
     * The autoClosingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $autoClosingDate;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * The signDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $signDueDate;
    /**
     * The submitDate
     * @var string
     */
    public $submitDate;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The signatureRequired
     * @var bool
     */
    public $signatureRequired;
    /**
     * The amountPaid
     * @var int
     */
    public $amountPaid;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The signPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $signPage;
    /**
     * Constructor method for contract
     * @uses Contract::setPublicId()
     * @uses Contract::setType()
     * @uses Contract::setTitle()
     * @uses Contract::setClosingDate()
     * @uses Contract::setAutoClosingDate()
     * @uses Contract::setCreateDate()
     * @uses Contract::setSignDueDate()
     * @uses Contract::setSubmitDate()
     * @uses Contract::setStatus()
     * @uses Contract::setSignatureRequired()
     * @uses Contract::setAmountPaid()
     * @uses Contract::setLanguage()
     * @uses Contract::setSignPage()
     * @param string $publicId
     * @param string $type
     * @param string $title
     * @param string $closingDate
     * @param string $autoClosingDate
     * @param string $createDate
     * @param string $signDueDate
     * @param string $submitDate
     * @param string $status
     * @param bool $signatureRequired
     * @param int $amountPaid
     * @param string $language
     * @param bool $signPage
     */
    public function __construct($publicId = null, $type = null, $title = null, $closingDate = null, $autoClosingDate = null, $createDate = null, $signDueDate = null, $submitDate = null, $status = null, $signatureRequired = null, $amountPaid = null, $language = null, $signPage = null)
    {
        $this
            ->setPublicId($publicId)
            ->setType($type)
            ->setTitle($title)
            ->setClosingDate($closingDate)
            ->setAutoClosingDate($autoClosingDate)
            ->setCreateDate($createDate)
            ->setSignDueDate($signDueDate)
            ->setSubmitDate($submitDate)
            ->setStatus($status)
            ->setSignatureRequired($signatureRequired)
            ->setAmountPaid($amountPaid)
            ->setLanguage($language)
            ->setSignPage($signPage);
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \StructType\Contract
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ContractType::valueIsValid()
     * @uses \EnumType\ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Contract
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContractType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ContractType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Contract
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($title) && mb_strlen($title) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get closingDate value
     * @return string|null
     */
    public function getClosingDate()
    {
        return $this->closingDate;
    }
    /**
     * Set closingDate value
     * @param string $closingDate
     * @return \StructType\Contract
     */
    public function setClosingDate($closingDate = null)
    {
        // validation for constraint: string
        if (!is_null($closingDate) && !is_string($closingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingDate, true), gettype($closingDate)), __LINE__);
        }
        $this->closingDate = $closingDate;
        return $this;
    }
    /**
     * Get autoClosingDate value
     * @return string|null
     */
    public function getAutoClosingDate()
    {
        return $this->autoClosingDate;
    }
    /**
     * Set autoClosingDate value
     * @param string $autoClosingDate
     * @return \StructType\Contract
     */
    public function setAutoClosingDate($autoClosingDate = null)
    {
        // validation for constraint: string
        if (!is_null($autoClosingDate) && !is_string($autoClosingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($autoClosingDate, true), gettype($autoClosingDate)), __LINE__);
        }
        $this->autoClosingDate = $autoClosingDate;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\Contract
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get signDueDate value
     * @return string|null
     */
    public function getSignDueDate()
    {
        return $this->signDueDate;
    }
    /**
     * Set signDueDate value
     * @param string $signDueDate
     * @return \StructType\Contract
     */
    public function setSignDueDate($signDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($signDueDate) && !is_string($signDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signDueDate, true), gettype($signDueDate)), __LINE__);
        }
        $this->signDueDate = $signDueDate;
        return $this;
    }
    /**
     * Get submitDate value
     * @return string|null
     */
    public function getSubmitDate()
    {
        return $this->submitDate;
    }
    /**
     * Set submitDate value
     * @param string $submitDate
     * @return \StructType\Contract
     */
    public function setSubmitDate($submitDate = null)
    {
        // validation for constraint: string
        if (!is_null($submitDate) && !is_string($submitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submitDate, true), gettype($submitDate)), __LINE__);
        }
        $this->submitDate = $submitDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ContractStatus::valueIsValid()
     * @uses \EnumType\ContractStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Contract
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContractStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ContractStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get signatureRequired value
     * @return bool|null
     */
    public function getSignatureRequired()
    {
        return $this->signatureRequired;
    }
    /**
     * Set signatureRequired value
     * @param bool $signatureRequired
     * @return \StructType\Contract
     */
    public function setSignatureRequired($signatureRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureRequired) && !is_bool($signatureRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signatureRequired, true), gettype($signatureRequired)), __LINE__);
        }
        $this->signatureRequired = $signatureRequired;
        return $this;
    }
    /**
     * Get amountPaid value
     * @return int|null
     */
    public function getAmountPaid()
    {
        return $this->amountPaid;
    }
    /**
     * Set amountPaid value
     * @param int $amountPaid
     * @return \StructType\Contract
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: int
        if (!is_null($amountPaid) && !(is_int($amountPaid) || ctype_digit($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        $this->amountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\Contract
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get signPage value
     * @return bool|null
     */
    public function getSignPage()
    {
        return $this->signPage;
    }
    /**
     * Set signPage value
     * @param bool $signPage
     * @return \StructType\Contract
     */
    public function setSignPage($signPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($signPage) && !is_bool($signPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($signPage, true), gettype($signPage)), __LINE__);
        }
        $this->signPage = $signPage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
