<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Signatory ServiceType
 * @subpackage Services
 */
class Signatory extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named signatorySendSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignatorySendSmsRequest $signatorySendSmsRequest
     * @return \StructType\SignatorySendSmsResponse|bool
     */
    public function signatorySendSms(\StructType\SignatorySendSmsRequest $signatorySendSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendSms($signatorySendSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySendAllSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignatorySendAllSmsRequest $signatorySendAllSmsRequest
     * @return \StructType\SignatorySendAllSmsResponse|bool
     */
    public function signatorySendAllSms(\StructType\SignatorySendAllSmsRequest $signatorySendAllSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendAllSms($signatorySendAllSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySendOneSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignatorySendOneSmsRequest $signatorySendOneSmsRequest
     * @return \StructType\SignatorySendOneSmsResponse|bool
     */
    public function signatorySendOneSms(\StructType\SignatorySendOneSmsRequest $signatorySendOneSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendOneSms($signatorySendOneSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SignatorySignRequest $signatorySignRequest
     * @return \StructType\SignatorySignResponse|bool
     */
    public function signatorySign(\StructType\SignatorySignRequest $signatorySignRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySign($signatorySignRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SignatorySendAllSmsResponse|\StructType\SignatorySendOneSmsResponse|\StructType\SignatorySendSmsResponse|\StructType\SignatorySignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
