<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contract ServiceType
 * @subpackage Services
 */
class Contract extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named contractDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractDeleteRequest $contractDeleteRequest
     * @return \StructType\ContractDeleteResponse|bool
     */
    public function contractDelete(\StructType\ContractDeleteRequest $contractDeleteRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractDelete($contractDeleteRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractCancelRequest $contractCancelRequest
     * @return \StructType\ContractCancelResponse|bool
     */
    public function contractCancel(\StructType\ContractCancelRequest $contractCancelRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractCancel($contractCancelRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractCreateRequest $contractCreateRequest
     * @return \StructType\ContractCreateResponse|bool
     */
    public function contractCreate(\StructType\ContractCreateRequest $contractCreateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractCreate($contractCreateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractDetailRequest $contractDetailRequest
     * @return \StructType\ContractDetailResponse|bool
     */
    public function contractDetail(\StructType\ContractDetailRequest $contractDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractDetail($contractDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractFinalize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractFinalizeRequest $contractFinalizeRequest
     * @return \StructType\ContractFinalizeResponse|bool
     */
    public function contractFinalize(\StructType\ContractFinalizeRequest $contractFinalizeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractFinalize($contractFinalizeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContractListRequest $contractListRequest
     * @return \StructType\ContractListResponse|bool
     */
    public function contractList(\StructType\ContractListRequest $contractListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractList($contractListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ContractCancelResponse|\StructType\ContractCreateResponse|\StructType\ContractDeleteResponse|\StructType\ContractDetailResponse|\StructType\ContractFinalizeResponse|\StructType\ContractListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
