<?php

namespace EnumType;

/**
 * This class stands for smsActionResult EnumType
 * @subpackage Enumerations
 */
class SmsActionResult
{
    /**
     * Constant for value 'already_signed'
     * @return string 'already_signed'
     */
    const VALUE_ALREADY_SIGNED = 'already_signed';
    /**
     * Constant for value 'denied'
     * @return string 'denied'
     */
    const VALUE_DENIED = 'denied';
    /**
     * Constant for value 'success'
     * @return string 'success'
     */
    const VALUE_SUCCESS = 'success';
    /**
     * Constant for value 'sms_quota_reached'
     * @return string 'sms_quota_reached'
     */
    const VALUE_SMS_QUOTA_REACHED = 'sms_quota_reached';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALREADY_SIGNED
     * @uses self::VALUE_DENIED
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_SMS_QUOTA_REACHED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALREADY_SIGNED,
            self::VALUE_DENIED,
            self::VALUE_SUCCESS,
            self::VALUE_SMS_QUOTA_REACHED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
