<?php

namespace EnumType;

/**
 * This class stands for signatoryStatus EnumType
 * @subpackage Enumerations
 */
class SignatoryStatus
{
    /**
     * Constant for value 'rejected'
     * @return string 'rejected'
     */
    const VALUE_REJECTED = 'rejected';
    /**
     * Constant for value 'signed'
     * @return string 'signed'
     */
    const VALUE_SIGNED = 'signed';
    /**
     * Constant for value 'signed_not_paid'
     * @return string 'signed_not_paid'
     */
    const VALUE_SIGNED_NOT_PAID = 'signed_not_paid';
    /**
     * Constant for value 'signing'
     * @return string 'signing'
     */
    const VALUE_SIGNING = 'signing';
    /**
     * Constant for value 'sms_blocked'
     * @return string 'sms_blocked'
     */
    const VALUE_SMS_BLOCKED = 'sms_blocked';
    /**
     * Constant for value 'suspended'
     * @return string 'suspended'
     */
    const VALUE_SUSPENDED = 'suspended';
    /**
     * Constant for value 'validated'
     * @return string 'validated'
     */
    const VALUE_VALIDATED = 'validated';
    /**
     * Constant for value 'waiting'
     * @return string 'waiting'
     */
    const VALUE_WAITING = 'waiting';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_SIGNED
     * @uses self::VALUE_SIGNED_NOT_PAID
     * @uses self::VALUE_SIGNING
     * @uses self::VALUE_SMS_BLOCKED
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_VALIDATED
     * @uses self::VALUE_WAITING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REJECTED,
            self::VALUE_SIGNED,
            self::VALUE_SIGNED_NOT_PAID,
            self::VALUE_SIGNING,
            self::VALUE_SMS_BLOCKED,
            self::VALUE_SUSPENDED,
            self::VALUE_VALIDATED,
            self::VALUE_WAITING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
